/*
	custom implementation for vsprintf_spu
*/ 

#if defined(PS3)

#include <stdarg.h>

#define ZEROPAD	1
#define SIGN	2	
#define SPACE	8	
#define LEFT	16
#define LARGE	64

__attribute__((always_inline))
inline int do_div(uint64& n, int base)
{
	int __res;
	__res = ((unsigned long)n) % (uint32)base;
	n = ((unsigned long)n) / (uint32)base;
	return __res;
}

inline int skip_atoi(const char **s)
{
	int i=0;

	while (isdigit(**s))
		i = i*10 + *((*s)++) - '0';
	return i;
}

__attribute__((always_inline))
inline int strnlen(const char* szString, const int precision)
{
	const char* p;
	const char* szStringEnd = szString + precision;
	for (p = szString; p < szStringEnd && *p; ++p)
		continue;

	return p - szString;
}

static char * number(char * buf, char * end, uint64 num, int base, int size, int precision, int type)
{
	char c,sign,tmp[66];
	const char *digits;
	static const char small_digits[] = "0123456789abcdefghijklmnopqrstuvwxyz";
	static const char large_digits[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	int i;

	digits = (type & LARGE) ? large_digits : small_digits;
	if (type & LEFT)
		type &= ~ZEROPAD;
	if (base < 2 || base > 36)
		return NULL;
	c = (type & ZEROPAD) ? '0' : ' ';
	sign = 0;
	if (type & SIGN) 
	{
		if ((int64) num < 0)
		{
			sign = '-';
			num = - (int64) num;
			size--;
		} 
		else if (type & SPACE) 
		{
			sign = ' ';
			size--;
		}
	}
	i = 0;
	if (num == 0)
		tmp[i++]='0';
	else while (num != 0)
		tmp[i++] = digits[do_div(num,base)];
	if (i > precision)
		precision = i;
	size -= precision;
	if (!(type&(ZEROPAD+LEFT))) 
	{
		while(size-->0) 
		{
			if (buf <= end)
				*buf = ' ';
			++buf;
		}
	}
	if (sign) 
	{
		if (buf <= end)
			*buf = sign;
		++buf;
	}
	if (!(type & LEFT)) 
	{
		while (size-- > 0) 
		{
			if (buf <= end)
				*buf = c;
			++buf;
		}
	}
	while (i < precision--)
	{
		if (buf <= end)
			*buf = '0';
		++buf;
	}
	while (i-- > 0) 
	{
		if (buf <= end)
			*buf = tmp[i];
		++buf;
	}
	while (size-- > 0)
	{
		if (buf <= end)
			*buf = ' ';
		++buf;
	}
	return buf;
}

inline void vsprintf_spu(char *buf, const char *fmt, va_list args)
{
	size_t size = SPU_PRINTF_BUF_SIZE;
	int len;
	uint64 num;
	int i, base;
	char *str, *end, c;
	const char *s;

	int flags;		/* flags to number() */

	int field_width;	/* width of output field */
	int precision;		/* min. # of digits for integers; max
										number of chars for from string */
	int qualifier;		/* 'h', 'l', or 'L' for integer fields */
	str = buf;
	end = buf + size - 1;

	for (; *fmt ; ++fmt) 
	{
		if (*fmt != '%')
		{
			if (str <= end)
				*str = *fmt;
			++str;
			continue;
		}

		/* process flags */
		flags = 0;
repeat:
		++fmt;		// this also skips first '%'
		switch (*fmt)
		{
				case '-': flags |= LEFT; goto repeat;
				case ' ': flags |= SPACE; goto repeat;
				case '0': flags |= ZEROPAD; goto repeat;
		}

		field_width = -1;
		if (isdigit(*fmt))
			field_width = skip_atoi(&fmt);
		else if (*fmt == '*') 
		{
			++fmt;
			/* it's the next argument */
			field_width = va_arg(args, int);
			if (field_width < 0)
			{
				field_width = -field_width;
				flags |= LEFT;
			}
		}

		/* get the precision */
		precision = -1;
		if (*fmt == '.') 
		{
			++fmt;	
			if (isdigit(*fmt))
				precision = skip_atoi(&fmt);
			else if (*fmt == '*')
			{
				++fmt;
				/* it's the next argument */
				precision = va_arg(args, int);
			}
			if (precision < 0)
				precision = 0;
		}

		/* get the conversion qualifier */
		qualifier = -1;
		if (*fmt == 'h' || *fmt == 'l' || *fmt == 'L' ||
			*fmt =='Z' || *fmt == 'z' || *fmt == 't') {
				qualifier = *fmt;
				++fmt;
				if (qualifier == 'l' && *fmt == 'l') {
					qualifier = 'L';
					++fmt;
				}
		}

		/* default base */
		base = 10;

		switch (*fmt)
		{
			case 'c':
				if (!(flags & LEFT))
				{
					while (--field_width > 0) 
					{
						if (str <= end)
							*str = ' ';
						++str;
					}
				}
				c = (uint8) va_arg(args, int);
				if (str <= end)
					*str = c;
				++str;
				while (--field_width > 0) 
				{
					if (str <= end)
						*str = ' ';
					++str;
				}
				continue;

			case 's':
				s = va_arg(args, char *);
				if ((uint32)s == 0)
					s = "<NULL>";

				len = strnlen(s, precision);

				if (!(flags & LEFT)) 
				{
					while (len < field_width--) 
					{
						if (str <= end)
							*str = ' ';
						++str;
					}
				}
				for (i = 0; i < len; ++i) 
				{
					if (str <= end)
						*str = *s;
					++str; ++s;
				}
				while (len < field_width--)
				{
					if (str <= end)
						*str = ' ';
					++str;
				}
				continue;

			case 'p':
				if (field_width == -1) 
				{
					field_width = 2*sizeof(void *);
					flags |= ZEROPAD;
				}
				str = number(str, end,(uint32) va_arg(args, void *), 16, field_width, precision, flags);
				continue;

			case 'n':
				if (qualifier == 'l') 
				{
					int * ip = va_arg(args, int *);
					*ip = (str - buf);
				} 
				else if (qualifier == 'Z' || qualifier == 'z') 
				{
					size_t * ip = va_arg(args, size_t *);
					*ip = (str - buf);
				} 
				else
				{
					int * ip = va_arg(args, int *);
					*ip = (str - buf);
				}
				continue;

			case '%':
				if (str <= end)
					*str = '%';
				++str;
				continue;

			case 'o':
				base = 8;
				break;

			case 'X':
				flags |= LARGE;
			case 'f'://FIXME
			case 'x':
				base = 16;
				break;

			case 'd':
			case 'i':
				flags |= SIGN;
			case 'u':
				break;

			default:
				if (str <= end)
					*str = '%';
				++str;
				if (*fmt) 
				{
					if (str <= end)
						*str = *fmt;
					++str;
				} 
				else 
					--fmt;
				continue;
		}
		if (qualifier == 'L')
			num = va_arg(args, long long);
		else 
		if (qualifier == 'Z' || qualifier == 'z') 
		{
			num = va_arg(args, size_t);
		} 
		else if (qualifier == 't')
		{
			num = va_arg(args, ptrdiff_t);
		} 
		else if (qualifier == 'h') 
		{
			num = (uint16) va_arg(args, int);
			if (flags & SIGN)
				num = (int16) num;
		} 
		else
		{
			num = va_arg(args, uint32);
			if (flags & SIGN)
				num = (signed int) num;
		}
		str = number(str, end, num, base,	field_width, precision, flags);
	}
	if (str <= end)
		*str = '\0';
	else if (size > 0)
		*end = '\0';
}

#endif //PS3
