////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) SN Systems Ltd 2005-2009
//
//  Description:  Tuner for PS3 - Library Functions
//
//  Change History:
//
//  Vers      Date            Author        Changes
//  1.9       06-Jan-2009     Tom           Added snRSXSetMaxMemoryForMarkers()
//  1.8       20-May-2008     Tom           Added snPushMarker() & snPopMarker() [sdk220+]
//  1.7       18-Apr-2008     Tom           Added snRegisterGetGcmContextCB()
//  1.6       26-Feb-2008     Tom           Added snRegisterGcmFlush()
//                                          Moved deprecated RSX marker funcs into their own .obj inside the lib
//  1.5       06-Sep-2007     Tom           Fwd declared CellGcmContextData, removing need to include gcm.h beforehand
//  1.4       09-Jul-2007     Tom           Added snRSXMarkerSync(), snRSXGetMaxMarkers(),
//                                                snRSXPushMarker() & snRSXPopMarker()
//  1.3       24-Jul-2006     Tom           Added snStartCapture()/snStopCapture()
//  1.2       26-Apr-2006     Tom           Renamed from SNTuner.h to libsntuner.h
//                                          Added __SN_Libsntuner_version
//  1.1       03-Apr-2006     Tom           Moved snIsTunerRunning() from libsn.h
//  1.0       26-Nov-2005     Tom           First release
//
////////////////////////////////////////////////////////////////////////////////

#ifndef __SNTUNER_H__
#define __SNTUNER_H__

#ifdef __cplusplus
extern "C" {
#endif

	int snPushMarker(const char *pText);
	int snPopMarker();
	void snStartMarker(unsigned int uID, const char *pText);
	void snStopMarker(unsigned int uID);
	void snStartCapture();
	void snStopCapture();

	int snIsTunerRunning (void);

	struct CellGcmContextData;
	int snRSXSetMaxMemoryForMarkers(uint32_t uMB, /*OUT*/ void** ppEA, /*OUT*/ uint32_t* pIO);
														// Returns:
														// . uMB rounded-down to nearest power-of-2-megabyte (1,2,4,8,16MB) or error(<0)
														// . *pEA and *pIO are function outputs
														// Side affects:
														// - Resets all internal RSX markers vars (eg. stack) & re-inits EA/IO addrs used by Tuner

	unsigned int snRSXGetMaxMarkers();					// Returns internal MaxMemoryForMarkers * 1MB / sizeof(CellGcmReportData)
														// Default is: 1MB / 32B = 32K

	void snRegisterGcmFlush( void (*pMyGcmFlush)(CellGcmContextData*) );
	void snRegisterGetGcmContextCB( CellGcmContextData* (*pMyGetGcmContextCB)(void) );

	// Deprecated from sdk220 - use cellGcmSetPerfMonPushMarker(), cellGcmSetPerfMonPopMarker()
	int snRSXMarkerSync(CellGcmContextData* thisContext, void* pRsxReportEA, uint32_t uRsxReportOffset);
	int snRSXPushMarker(CellGcmContextData* thisContext, const char *pText);	// Returns SUCCEEDED(0) or error(<0)
	int snRSXPopMarker(CellGcmContextData* thisContext);	// Returns SUCCEEDED(0) or error(<0)

	// For backwards compatibility:
	int snTunerInit();
	#define snIsTunerPresent snIsTunerRunning

	extern unsigned int __SN_Libsntuner_version[];

#ifdef __cplusplus
}
#endif

#endif /* __SNTUNER_H__ */
