#include <string>
#include <algorithm>
#include <functional>
#include <iostream>
#include <cassert>
#include <cstring>
#include <sys/stat.h>

#include "DeVirt.h"
#include "Util.h"

namespace 
{
  static const char s_Win32PathSeperator = '\\';
  static const char s_LinuxPathSeperator = '/';
  static const char s_Seperators[2] = 
#ifdef WIN32 
  {s_Win32PathSeperator,s_LinuxPathSeperator};
#else
  {s_LinuxPathSeperator,s_Win32PathSeperator};
#endif 
};

namespace Util
{
  const char PathSeperator = s_Seperators[0];

  std::string ConvertPath(std::string path)
  {
    std::replace_if(path.begin(),
                    path.end(),
                    std::bind2nd(std::equal_to<char>(),s_Seperators[1]),
                    s_Seperators[0]);
    assert(CheckPath(path));
    return path;
  }

  char* ConvertPath(char *path)
  {
    assert(path);
    char *begin = path;
    char *end = path+std::strlen(path);
    std::replace_if(begin,
                    end,
                    std::bind2nd(std::equal_to<char>(),s_Seperators[1]),
                    s_Seperators[0]);
    assert(CheckPath(path));
    return path;
  }

  bool CheckPath(const std::string &path)
  {
    std::string::const_iterator check = 
      std::find_if(path.begin(),
                   path.end(),
                   std::bind2nd(std::equal_to<char>(),s_Seperators[1]));
    return (check==path.end()) ? true : false;
  }

  bool CheckPath(const char *path)
  {
    assert(path);
    const char *begin = path;
    const char *end = path+std::strlen(path);
    const char *check = 
      std::find_if(begin,
                   end,
                   std::bind2nd(std::equal_to<char>(),s_Seperators[1]));
    return (check==end) ? true : false;
  }

	std::string GetPath( const std::string &file )
	{
		// find last / or
		size_t pos = file.rfind( Util::PathSeperator );

		if( pos == std::string::npos )
			return "";

		return std::string( file, 0 , pos );
	}

	bool CreateDirectories( const std::set<std::string> &directories )
	{
		for( std::set<std::string>::const_iterator directory = directories.begin() ;
			directory != directories.end() ; ++directory )
		{
			struct stat sbuf;
			if (stat(directory->c_str(), &sbuf) == 0)
			{
				if (!S_ISDIR(sbuf.st_mode))
				{
					std::cerr << "directory path " << *directory << " is not a directory" << std::endl;						
					return false;
				}
			}
			else 
			{
				// create directories sort like recursive, since the system function on windows only create the last directory
				// and no possible missing directories in between
				std::string dir = *directory;
				while(true)
				{
					if(dir.empty() || ( dir.find('/') == std::string::npos && dir.find('\\') == std::string::npos) )
					{
						std::cerr << "Can not create directory " <<  *directory << std::endl;
						return false;
					}

					if (mkdir(dir.c_str(), 0755) == -1)
					{
						dir = dir.substr(0, dir.rfind(Util::PathSeperator));
					}else {
						if( dir == *directory)
							break;
						dir = *directory;
					}					
				}
			}
		}

		return true;

	}
};
