#ifndef _Util_h_
#define _Util_h_ 1

#include <set>

namespace Util 
{
  // The character representing the host operating system path
  // seperator
  extern const char PathSeperator;

  // Converts a string containing a path to the host operating system
  // conventions regarding directory sepators et al.
  std::string ConvertPath(std::string path);
  char* ConvertPath(char *path);
 
  // Converts a string containing a path to the host operating system
  // conventions regarding directory sepators et al.
  bool CheckPath(const std::string &path);
  bool CheckPath(const char *path);
	std::string GetPath( const std::string &file );

  bool CreateDirectories( const std::set<std::string> &directories );

};

#endif

