

#include "stdafx.h"
#include "PhotoBump10.h"
#include "PhotoBump10Doc.h"
#include "PhotoBump10View.h"
#include "Video.h"
#include "PhotoFrame.h"
#include "PVertex.h"
#include "PQuadtree.h"
#include "PhotoImage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////////
bool CPhotoBump10Doc::ExportObj(const char *_szFilename)
{
	if (m_lstFrames.empty())
		return (false);
	
	//PolygonReduction();

	int w=m_lstFrames[KEY_FRAME]->m_pImage->m_nWidth;
	int h=m_lstFrames[KEY_FRAME]->m_pImage->m_nHeight;
	CPhotoFrame *pFrame=m_lstFrames[KEY_FRAME];

	char szPath[512];
	strcpy(szPath,m_pUtils->GetPath(_szFilename));
	char szFilename[512];

	char szFile[512];
	strcpy(szFile,m_pUtils->GetFilename(m_szDataLoad));
	m_pUtils->RemoveExtension(szFile);

	// export material
	sprintf(szFilename,"%s%s.mtl",szPath,szFile);
	FILE *fp=fopen(szFilename,"wb");
	if (!fp)
		return (false);
	fprintf(fp,"#\n# .MTL file generated by PhotoBump\n#\n");
	fprintf(fp,"newmtl Mat_1\n");
	fprintf(fp,"\tKd 1 1 1\n\tKa 1 1 1\n\tKs 1 1 1\n\tillum 0\n");			
	//fprintf(fp,"map_Kd %s_Texture.tga",szFile); 
	fprintf(fp,"map_Kd %s",m_pUtils->GetFilename(m_szDataLoad));
	fclose(fp);
	
	// export .obj file
	sprintf(szFilename,"%s%s.obj",szPath,szFile);
	fp=fopen(szFilename,"wb");
	if (!fp)
		return (false);
	fprintf(fp,"#\n# .OBJ file generated by PhotoBump\n#\n\n");
	fprintf(fp,"mtllib %s.mtl\n\n",szFile);		
	int nScale=2;
	float *pVert=m_Vertices;
#ifdef USE_GL_LIGHT
	int nStride=8;
#else
	int nStride=5;
#endif
	fprintf(fp,"#\n# mesh vertices (total:%d, valid=%d)\n# 3d coord, normal, texture coords \n#\n",w/nScale*h/nScale,m_nNumVertices);
	pVert=m_Vertices;
	for (int k=0;k<m_nNumVertices;k++,pVert+=nStride)
	{
		//if (pVert[0]==0 && pVert[1]==0)
		//	continue;
		fprintf(fp,"v %0.8f %0.8f %0.8f\n",pVert[0],pVert[1],pVert[2]);		
	} //k
#ifdef USE_GL_LIGHT
	pVert=m_Vertices;
	for (int k=0;k<m_nNumVertices;k++,pVert+=nStride)
	{
		//if (pVert[0]==0 && pVert[1]==0)
		//	continue;
		fprintf(fp,"vn %0.8f %0.8f %0.8f\n",pVert[5],pVert[6],pVert[7]);
	} //k
#endif
	pVert=m_Vertices;
	for (int k=0;k<m_nNumVertices;k++,pVert+=nStride)
	{
		//if (pVert[0]==0 && pVert[1]==0)
		//	continue;
		fprintf(fp,"vt %0.8f %0.8f\n",pVert[3],pVert[4]);
	} //k	
 
	fprintf(fp,"#\n# mesh faces v/t/n (%d)\n#\n",m_nNumIndexes/3);
	fprintf(fp,"g Mesh\nusemtl Mat_1\n");
	for (int k=0;k<m_nNumIndexes;k+=3)
	{
		int v1=m_Indices[k+0]+1;
		int v2=m_Indices[k+1]+1;
		int v3=m_Indices[k+2]+1;
#ifdef USE_GL_LIGHT		 
		fprintf(fp,"f %d/%d/%d %d/%d/%d %d/%d/%d \n",v1,v1,v1,v2,v2,v2,v3,v3,v3);
#else		
		fprintf(fp,"f %d/%d %d/%d %d/%d \n",v1,v1,v2,v2,v3,v3);
#endif
	} //k
	fclose(fp);

	return (true);
}

// invert RG values only - temporary fix for normal maps already done
//////////////////////////////////////////////////////////////////////////
uchar *CPhotoBump10Doc::InvertChannels(const char *szFilename,int &nW,int &nH)
{
	CPhotoImage *pImg=m_pVideo->LoadTexture(szFilename,CGTEXT_FLAG_DONOTUPLOAD|CGTEXT_FLAG_KEEP);
	if (!pImg)
		return (NULL);

	nW=pImg->m_nWidth;
	nH=pImg->m_nHeight;
	uchar *szRes=new uchar [nW*nH*3];
	for (int k=0;k<nW*nH;k++)
	{
		szRes[k*3+0]=255-pImg->m_pRawPixels[k*3+0];
		szRes[k*3+1]=255-pImg->m_pRawPixels[k*3+1];
		szRes[k*3+2]=pImg->m_pRawPixels[k*3+2];
	} //k

	m_pVideo->RemoveTexture(pImg);

	return (szRes);
}

//////////////////////////////////////////////////////////////////////////
uchar *CPhotoBump10Doc::SwapRGChannelsInvertRGValues(const char *szFilename,int &nW,int &nH)
{
	CPhotoImage *pImg=m_pVideo->LoadTexture(szFilename,CGTEXT_FLAG_DONOTUPLOAD|CGTEXT_FLAG_KEEP);
	if (!pImg)
		return (NULL);

	nW=pImg->m_nWidth;
	nH=pImg->m_nHeight;
	uchar *szRes=new uchar [nW*nH*3];
	for (int k=0;k<nW*nH;k++)
	{
		szRes[k*3+0]=255-pImg->m_pRawPixels[k*3+1];
		szRes[k*3+1]=255-pImg->m_pRawPixels[k*3+0];
		szRes[k*3+2]=pImg->m_pRawPixels[k*3+2];
	} //k

	m_pVideo->RemoveTexture(pImg);

	return (szRes);
}

/*
//////////////////////////////////////////////////////////////////////////
uchar *CPhotoBump10Doc::ConvertToHeightmap(const char *szFilename,int &nW,int &nH,int nIters)
{
	CPhotoImage *pImg=m_pVideo->LoadTexture(szFilename,CGTEXT_FLAG_DONOTUPLOAD|CGTEXT_FLAG_KEEP);
	if (!pImg)
		return (NULL);

	nW=pImg->m_nWidth;
	nH=pImg->m_nHeight;

	return (GenerateHeightMap(pImg->m_pRawPixels,nW,nH,nIters));	
}
*/
