// Copyright: (c) by Crytek GmbH
#include "stdafx.h"														// for precompiled headers (has to be in first place)
#include "3DLight.h"													// C3DLight
#include "assert.h"														// assert()
#include "3DRenderer.h"												// C3DRenderer
#include "Error.h"														// Error,Message
#include "3DMaterial.h"												// POLYBUMPVERTEX
#include "3DTools.h"													// Build3DCone


//! constructor
C3DLight::C3DLight()
{
	m_Color.r=1.0f;m_Color.r=1.0f;m_Color.r=1.0f;m_Color.a=1.0f;
}

//! destructor
C3DLight::~C3DLight()
{
}







//! only used for debugging (not optimized)
void C3DLight::Render( C3DRenderer &inRenderer )
{
	const int _ARROW_CY_SIDES=32;
	const int _POINT_CY_SIDES=4;

	IDirect3DDevice8 *pDev=inRenderer.GetDirectXDevice();				assert(pDev);

	pDev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);

	pDev->SetPixelShader(0);
	pDev->SetTexture(0,0);
	pDev->SetTexture(1,0);
	pDev->SetTexture(3,0);
	pDev->SetRenderState(D3DRS_SPECULARENABLE,FALSE);
	pDev->SetTextureStageState(0,D3DTSS_COLORARG1,D3DTA_TFACTOR);
	pDev->SetTextureStageState(0,D3DTSS_COLOROP,D3DTOP_SELECTARG1);
	pDev->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );
	pDev->SetRenderState(D3DRS_TEXTUREFACTOR,D3DXCOLOR(m_Color));

	pDev->SetRenderState(D3DRS_ZFUNC,D3DCMP_LESS);
	pDev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	pDev->SetRenderState(D3DRS_DESTBLEND,D3DBLEND_ZERO);
	pDev->SetRenderState(D3DRS_SRCBLEND,D3DBLEND_ONE);

	POLYBUMPVERTEX array[_ARROW_CY_SIDES*2+2];

	pDev->SetVertexShader(inRenderer.m_ShaderManager.m_dwVS_Standard);

	D3DXVECTOR3 vTo;
	D3DXVECTOR3 vFrom;
	D3DXVECTOR3 vDir=GetTo()-GetFrom();
	float fLength=D3DXVec3Length(&(GetFrom()-GetTo()));

	if(inRenderer.GetForceDirLight())											// directional light
	{
		// Arrow consists of 3 Cones
		vFrom=GetFrom()-vDir*0.5f;
		vTo=GetFrom()-vDir*0.51f;
		Build3DCone(array,_ARROW_CY_SIDES,fLength*0.03f,0,vFrom,vTo);
		pDev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,_ARROW_CY_SIDES*2,array,sizeof(POLYBUMPVERTEX));

		vFrom=GetFrom()-vDir*0.3f;
		vTo=GetFrom()-vDir*0.5f;
		Build3DCone(array,_ARROW_CY_SIDES,fLength*0.03f,fLength*0.03f,vFrom,vTo);
		pDev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,_ARROW_CY_SIDES*2,array,sizeof(POLYBUMPVERTEX));

		vFrom=GetFrom()-vDir*0.3f;
		vTo=GetFrom()-vDir*0.1f;
		Build3DCone(array,_ARROW_CY_SIDES,fLength*0.05f,0.0f,vFrom,vTo);
		pDev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,_ARROW_CY_SIDES*2,array,sizeof(POLYBUMPVERTEX));
	}
	else																									// point light
	{
		vFrom=GetFrom()-vDir*0.03f;
		vTo=GetFrom();
		Build3DCone(array,_POINT_CY_SIDES,0,fLength*0.03f,vFrom,vTo);
		pDev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,_POINT_CY_SIDES*2,array,sizeof(POLYBUMPVERTEX));

		vFrom=GetFrom();
		vTo=GetFrom()+vDir*0.03f;
		Build3DCone(array,_POINT_CY_SIDES,fLength*0.03f,0,vFrom,vTo);
		pDev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,_POINT_CY_SIDES*2,array,sizeof(POLYBUMPVERTEX));
	}
}



void C3DLight::SetColor( D3DXCOLOR inColor )
{
	m_Color=inColor;
}

D3DXCOLOR C3DLight::GetColor()
{
	return(m_Color);
}



