// Copyright: (c) by Crytek GmbH
#include "stdafx.h"														// for precompiled headers (has to be in first place)
#include "3DScene.h"													// C3DScene
#include "3DRenderer.h"												// C3DRenderer



// constructor
C3DScene::C3DScene()
{
	m_AmbientColor=D3DXCOLOR(0.0f,0.0f,0.0f,0.0f);
//	SetStats(0,0);
}

// destructor
C3DScene::~C3DScene()
{
	FreeLights();
	FreeObjects();
}


// render all objects in the scene
void C3DScene::Render( C3DRenderer &inRenderer )
{
	{
		vector<C3DObject *>::iterator it;

		for(it=m_Objects.begin();it!=m_Objects.end();++it)
			(*it)->Render(inRenderer,*this);
	}

	if(inRenderer.GetShowVertexBaseSpace() || inRenderer.GetShowTriBaseSpace() || inRenderer.GetShowNormals())	// reject early to prevent unneccessary Lock()
	{
		vector<C3DObject *>::iterator it;
		D3DXVECTOR3 vMin,vMax;
		float fScale;

		GetBoundingBox(vMin,vMax);

		fScale=inRenderer.GetDebugScale()*D3DXVec3Length(&(vMax-vMin))*0.01f;			// 1% of the object size

		for(it=m_Objects.begin();it!=m_Objects.end();++it)
			(*it)->RenderDebugHelper(inRenderer,fScale);
	}

	if(inRenderer.AskDrawLightSources())
	{
		vector<C3DLight *>::iterator it;

		for(it=m_Lights.begin();it!=m_Lights.end();++it)
			(*it)->Render(inRenderer);
	}
}


//
void C3DScene::FreeObjects()
{
	{
		vector<C3DObject *>::iterator it;

		for(it=m_Objects.begin();it!=m_Objects.end();++it)
			delete (*it);
	}
	m_Objects.clear();
}


void C3DScene::FreeLights()
{
	{
		vector<C3DLight *>::iterator it;

		for(it=m_Lights.begin();it!=m_Lights.end();++it)
			delete (*it);
	}

	m_Lights.clear();
}


//! get the bounding box O(1) (could be used to find the midpoint)
//! no objects -> BBox( (0,0,0)-(0,0,0) )
//! /param outMin minimum values for each axis
//! /param outMax maximum values for each axis
bool C3DScene::GetBoundingBox( D3DXVECTOR3 &outvMin, D3DXVECTOR3 &outvMax ) const
{
	if(m_Objects.empty())
	{
		outvMin=D3DXVECTOR3(0,0,0);
		outvMax=D3DXVECTOR3(0,0,0);
		return(false);
	}

	outvMin=D3DXVECTOR3(FLT_MAX,FLT_MAX,FLT_MAX);
	outvMax=D3DXVECTOR3(-FLT_MAX,-FLT_MAX,-FLT_MAX);

	vector<C3DObject *>::const_iterator it;

	for(it=m_Objects.begin();it!=m_Objects.end();++it)
	{
		D3DXVECTOR3 vMin,vMax;

		(*it)->GetBoundingBox(vMin,vMax);

		if(vMin.x<outvMin.x)outvMin.x=vMin.x;
		if(vMin.y<outvMin.y)outvMin.y=vMin.y;
		if(vMin.z<outvMin.z)outvMin.z=vMin.z;
		if(vMax.x>outvMax.x)outvMax.x=vMax.x;
		if(vMax.y>outvMax.y)outvMax.y=vMax.y;
		if(vMax.z>outvMax.z)outvMax.z=vMax.z;
	}

	return(true);
}



// 
C3DObject *C3DScene::LoadOBJAndAdd( C3DRenderer &inRenderer, const char *inszFileName, bool inbObjectSpace )
{
	C3DObject *pRet=new C3DObject();

	bool ret=pRet->LoadOBJ(inRenderer,inszFileName,inbObjectSpace);	// load object

	if(!ret)return(0);																							// fail

	m_Objects.push_back(pRet);																			// add element

	return(pRet);																										// success
}



//
C3DLight *C3DScene::AddLight()
{
	C3DLight *pRet=new C3DLight();

	m_Lights.push_back(pRet);								// add element

	return(pRet);
}



C3DLight *C3DScene::GetLightNo( DWORD indwNo )
{
	if(indwNo<m_Lights.size())return(m_Lights[indwNo]);
		else return(0);
}



void C3DScene::SetAmbientColor( D3DXCOLOR inAmbientColor )
{
	m_AmbientColor=inAmbientColor;
}

D3DXCOLOR C3DScene::GetAmbientColor()
{
	return(m_AmbientColor);
}



void C3DScene::GetStats( DWORD &outdwFaces, DWORD &outdwVertices )
{
	outdwFaces=0;
	outdwVertices=0;

//	outdwFaces=m_dwFaces;
//	outdwVertices=m_dwVertices;

	vector<C3DObject *>::const_iterator it;

	for(it=m_Objects.begin();it!=m_Objects.end();++it)
	{
		DWORD dwF,dwV;
		(*it)->GetStats(dwF,dwV);

		outdwFaces+=dwF;
		outdwVertices+=dwV;
	}
}

/*
//
void C3DScene::SetStats( DWORD indwFaces, DWORD indwVertices )
{
	m_dwFaces=indwFaces;
	m_dwVertices=indwVertices;
}
*/