// Copyright: (c) by Crytek GmbH
#pragma once

class C3DRenderer;
struct IDirect3DTexture8;



class C3DPixelShaderManager
{
public:

	//! constructor
	C3DPixelShaderManager();

	//! destructor
	virtual ~C3DPixelShaderManager();

	//! initialize the shaders (load, build)
	//! /param inRenderer reference to the render engine
	//! /return true=success, false otherwise
	bool Init( C3DRenderer &inRenderer );

	//! free the shaders
	//! /param inRenderer reference to the render engine
	void DeInit( C3DRenderer &inRenderer );



	// handle to the pixelshaders ********************************************

	DWORD										m_dwPS_PolyBumpDiffusePoint;		//!< diffuse material, point light (phong model)
	DWORD										m_dwPS_PolyBumpSpecDir;					//!< diffuse & specular material, parallel light (phong model)
	DWORD										m_dwPS_PolyBumpSpecPoint;				//!< diffuse & specular material, point light (phong model)
	DWORD										m_dwPS_PolyBumpSpecDirAtt;			//!< diffuse & specular material, parallel light with attenution (phong model)
	DWORD										m_dwPS_PolyBumpSpecPointAtt;		//!< diffuse & specular material, point light with attenution (phong model)
	// Pass1: Diffuse, Pass2: Specular
	DWORD										m_dwPS_PolyBumpSpecDir_CM;			//!< diffuse & specular material, parallel light (phong model), speuclar only, renormalizing
	DWORD										m_dwPS_PolyBumpDiffuseDir_CM;		//!< diffuse & specular material, parallel light (phong model), diffuse only, renormalizing

	// handle to the vertexshaders *******************************************

	DWORD										m_dwVS_PolyBumpDir;							//!< polybump vertex shader directional light
	DWORD										m_dwVS_PolyBumpPoint;						//!< polybump vertex shader point light
	DWORD										m_dwVS_Standard;								//!< diffuse+specular lighting vertex shader

	// texture interfaces ****************************************************

	IDirect3DCubeTexture8 *	m_pCubeNormalize;								//!< cubmap for normalization
	IDirect3DTexture8 *			m_pWhiteTexture;								//!< white texture for constistant look if a texture is missing
	IDirect3DTexture8 *			m_pDarkGreenTexture;						//!< dark green texture for OverdrawMeasure

	IDirect3DTexture8 *			m_pIrradianceTexture;						//!< irradiance map as in nvidia demo

private: // -----------------------------------------------------------------

	//! load pixel shader
	//! /param inpDevice pointer to the Direct3D Device
	//! /param inszFilename filename with path (e.g. "Quad.psh")
	//! /param outdwHandle handle to the pixel shader, otherwise 0
	//! /return true=success, false=failed
	bool LoadPixelShader( IDirect3DDevice8 *inpDevice, const char *inszFilename, DWORD &outdwHandle );

	//! load vertex shader
	//! /param inpDevice pointer to the Direct3D Device
	//! /param inszFilename filename with path (e.g. "Quad.vsh")
	//! /param outdwHandle handle to the vertex shader, otherwise 0
	//! /return true=success, false=failed
	bool LoadVertexShader( IDirect3DDevice8 *inpDevice, const char *inszFilename, DWORD &outdwHandle );

	//! is called by Init()
	//! /param inpDevice pointer to the Direct3D Device
	//! /param dwSize has to be power of two
	void BuildCubeNormalize( IDirect3DDevice8 *inpDevice, const DWORD dwSize );
};
