#pragma once

#include "D3dx8math.h"												// D3DXMATRIX, D3DXCreateTextureFromFile

// is used for cameras and lights
// (convenient rotation and movement methods)


class C3DTargetOrientation
{
public:
	//! constructor
									C3DTargetOrientation	( void );
	//! destructor
	virtual					~C3DTargetOrientation	( void );

	//! rotate around the target point
	//! /param infYaw horizontal
	//! /param infPitch vertical
	void						RotateAroundTarget		( const float infYaw, const float infPitch );

	//! get the view matrix (left handed)
	//! /param outMatrix result of the calculation
	void						GetViewTransform			( D3DXMATRIX &outMatrix ) const;

	//! get vectors in in Screenspace (normalized)
	//! /param outRight output for right vector (is normalized)
	//! /param outUp output for up vector (is normalized)
	//! /param outIn output for in vector (is normalized)
	void						GetBase								( D3DXVECTOR3 &outRight, D3DXVECTOR3 &outUp, D3DXVECTOR3 &outIn ) const;

	//! get direction (To-From).Normalize()
	//! /return normalized vector
	D3DXVECTOR3			GetDirection					( void ) const;
 
	// attributes ***************************************************************************

	//! get attribute	
	D3DXVECTOR3			GetTo									( void ) const;

	//! set attribute
	void						SetTo									( D3DXVECTOR3 &inTo );

	//! get attribute
	D3DXVECTOR3			GetFrom								( void ) const;

	//! set attribute
	void						SetFrom								( D3DXVECTOR3 &inFrom );

private:

	D3DXVECTOR3			m_vFrom;		//!< position in worldspace
	D3DXVECTOR3			m_vTo;			//!< position in worldspace 
	D3DXVECTOR3			m_vUp;			//!< up direction vector (normalized) usually (0,0,1)
};
