#ifndef __ChunkCompiler_h__
#define __ChunkCompiler_h__

#include "IConvertor.h"

struct ConvertContext;

class CChunkCompiler 
	: public ICompiler
	, public IConvertor
{
public:
	class Error
	{
	public:
		Error(int nCode);
		Error(const char* szFormat, ...);
		const char* c_str() const 
		{ 
			return m_strReason.c_str(); 
		}
	protected:
		string m_strReason;
	};

	CChunkCompiler();
	~CChunkCompiler();

	// ICompiler + IConvertor methods.
	virtual void Release();

	// ICompiler methods.
	virtual void BeginProcessing() { }
	virtual void EndProcessing() { }
	virtual bool Process(ConvertContext &cc);
	virtual void ConstructAndSetOutputFile(ConvertContext &cc);
	virtual void GetFilenameForUpToDateCheck(ConvertContext &cc, char* filenameBuffer, size_t bufferSize) const;

	// IConvertor methods.
	virtual void Init(IConfig* config, const char* exePath) { }
	virtual void DeInit() { }
	virtual ICompiler* CreateCompiler();
	virtual bool SupportsMultithreading() const;
	virtual int GetNumPlatforms() const;
	virtual EPlatform GetPlatform(int index) const;
	virtual int GetNumExt() const;
	virtual const char* GetExt(int index) const;
	virtual IConvertContext* CreateConvertContext() const;

private:
	int m_refCount;
};

#endif