#ifndef _MArrayDataHandle
#define _MArrayDataHandle
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MArrayDataHandle
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


class MArrayDataBuilder;

#include <maya/MStatus.h>
#include <maya/MTypes.h>
#include <string.h>
#include <maya/MDataHandle.h>
#include <maya/MArrayDataBuilder.h>

// ****************************************************************************
// CLASS DECLARATION (MArrayDataHandle)

//! \ingroup OpenMaya
//! \brief Data block handle for array data. 
/*!
  An MArrayDataHandle is a smart pointer into a data block (MDataBlock) that
  handles access to array data.  MArrayDataHandle supports attributes that
  can have an array of data.

  The array indices do not have to be continuous.  The array can be
  sparse.  Thus, an array could have four elements with the indicies
  1, 6, 8, and 10.

  MArrayDataHandle methods cannot be assumed to be threadsafe. The
  jumpToElement() method sets an internal pointer so definitely cannot
  be called by multiple threads simultaneously.

*/
class OPENMAYA_EXPORT MArrayDataHandle {

public:
	MArrayDataHandle( const MDataHandle & in, MStatus * ReturnStatus = NULL );

	MDataHandle       inputValue(MStatus *ReturnStatus = NULL);
	MDataHandle       outputValue(MStatus *ReturnStatus = NULL);
	MArrayDataHandle  inputArrayValue( MStatus * ReturnStatus = NULL );
	MArrayDataHandle  outputArrayValue( MStatus * ReturnStatus = NULL );
    MStatus           next();
	unsigned int          elementCount(MStatus *ReturnStatus = NULL);
	unsigned int          elementIndex(MStatus *ReturnStatus = NULL);
    MStatus           jumpToElement( unsigned int index );
    MStatus           jumpToArrayElement( unsigned int position );
    MStatus           setClean();
    MStatus           setAllClean();
	MArrayDataBuilder builder(MStatus *ReturnStatus = NULL);
	MStatus           set( MArrayDataBuilder &builder );

    MArrayDataHandle( const MArrayDataHandle &other );
	MArrayDataHandle& operator=( const MArrayDataHandle& other );

protected:
// No protected members

private:
	const char*		className() const;
	friend class MDataBlock;
	friend class MArrayDataBuilder;
	MArrayDataHandle( void* );
	MArrayDataHandle();
#ifdef MBits64_
	char data[40];
#else
	char data[20];
#endif
	bool fIsNull;
};

inline MArrayDataHandle::MArrayDataHandle( const MArrayDataHandle &other )
{
	memcpy( this, &other, sizeof(MArrayDataHandle) );
}

inline MArrayDataHandle& MArrayDataHandle::operator=(
											const MArrayDataHandle &other )
{
	memcpy( this, &other, sizeof(MArrayDataHandle) );
	return *this;
}

#endif /* __cplusplus */
#endif /* _MArrayDataHandle */
