#ifndef _MCommandMessage
#define _MCommandMessage
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MCommandMessage
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MMessage.h>
#include <maya/MString.h>

// ****************************************************************************
// CLASS DECLARATION (MCommandMessage)

//! \ingroup OpenMaya
//! \brief Helper class to handle MEL output. 
/*!
  This class is used to register for a callback for when certain MEL
  command related messages are generated.

  The add callback method returns an id which is used to remove the
  callback.

  To remove a callback use MMessage::removeCallback.

  All callbacks that are registered by a plug-in must be removed by
  that plug-in when it is unloaded. Failure to do so will result in a
  fatal error.

  \note 
  Setting up a callback using the addCommandCallback() method
  may degrade the performance of Maya since the installed callback
  will be invoked repeatedly as MEL operations are processed.
*/
class OPENMAYA_EXPORT MCommandMessage : public MMessage
{
public:
	//! Types of output messages
	enum MessageType {
		kHistory,		//!< Command history
		kDisplay,		//!< String to display unmodified
		kInfo,			//!< General information
		kWarning,		//!< Warning message
		kError,			//!< Error message
		kResult,		//!< Result from a command execution in the command window
		kStackTrace		//!< Stack trace
	};

	//! \brief Pointer to a message function.
	/*!
	  \param[in] message	The command that was executed.
	  \param[in] messageType	The type of message.
	  \param[in,out] clientData	User defined data passed to the callback function.
	 */
	typedef void (*MMessageFunction)( 
		const MString & message,
		MCommandMessage::MessageType messageType,
		void* clientData );

	//! \brief Pointer to a message filter function.
	/*!
	  \param[in] message		The command that was executed.
	  \param[in] messageType	The type of message.
	  \param[out] filter		Bool that causes Maya to filter this
		message if set to true.
	  \param[in,out] clientData	User defined data passed to the callback function.
	 */
	typedef void (*MMessageFilterFunction)( 
		const MString & message,
		MCommandMessage::MessageType messageType,
		bool& filterOutput,
		void* clientData );

	static MCallbackId	addCommandCallback(
								MMessage::MStringFunction func,
								void * clientData = NULL,
								MStatus * ReturnStatus = NULL );

	static MCallbackId	addCommandOutputCallback(
								MCommandMessage::MMessageFunction func,
								void * clientData = NULL,
								MStatus * ReturnStatus = NULL );

	static MCallbackId	addCommandOutputFilterCallback(
								MCommandMessage::MMessageFilterFunction func,
								void * clientData = NULL,
								MStatus * ReturnStatus = NULL );
private:
	static const char* className();
};

#endif /* __cplusplus */
#endif /* _MCommandMessage */
