#ifndef _MCommandResult
#define _MCommandResult
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MCommandResult
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MObject.h>

// ****************************************************************************
// FORWARD DECLARATIONS

class MIntArray;
class MDoubleArray;
class MString;
class MStringArray;
class MVector;
class MVectorArray;
class MMatrix;

// ****************************************************************************
// CLASS DECLARATION (MCommandResult)

//! \ingroup OpenMaya
//! \brief Result returned from executing a command. 
/*!
  MCommandResult collects the result returned by MGlobal::executeCommand.
  It can either be an int or an array of int or a double or an array of
  double or a string or an array of string. Use resultType to find out
  its type and use the appropriate getResult method to retrieve the result.
*/
class OPENMAYA_EXPORT MCommandResult {

public:
    //! The types of results that MEL commands can return.
    enum Type {
	  kInvalid = 0,		//!< \nop
	  kInt,			//!< \nop
	  kIntArray,		//!< \nop
	  kDouble,		//!< \nop
	  kDoubleArray,		//!< \nop
	  kString,		//!< \nop
	  kStringArray,		//!< \nop
	  kVector,		//!< \nop
      kVectorArray,		//!< \nop
      kMatrix,			//!< \nop
      kMatrixArray		//!< \nop
	};

    MCommandResult(MStatus* ReturnStatus = NULL );
	virtual         ~MCommandResult();
	Type            resultType(MStatus* ReturnStatus = NULL) const;
	MStatus         getResult( int& result) const;
    MStatus         getResult( MIntArray& result) const;
	MStatus         getResult( double& result) const;
	MStatus         getResult( MDoubleArray& result) const;
	MString			stringResult( MStatus *ReturnResult=NULL) const;
BEGIN_NO_SCRIPT_SUPPORT:
	//!     NO SCRIPT SUPPORT
	MStatus         getResult( MString& result) const;
END_NO_SCRIPT_SUPPORT:
	MStatus         getResult( MStringArray& result) const;
	MStatus         getResult( MVector& result) const;
	MStatus         getResult( MVectorArray& result) const;
	MStatus         getResult( MDoubleArray& result,
							   int &numRows, int &numColumns) const;
protected:
// No protected members

private:
    const char* className() const;
    void *fResult;
};

#endif /* __cplusplus */
#endif /* _MCommandResult */
