#ifndef _MCommonSystemUtils
#define _MCommonSystemUtils
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MCommonSystemUtils
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MString.h>
#include <maya/MTypes.h>

// ****************************************************************************
// CLASS DECLARATION (MCommonSystemUtils)

//! \ingroup OpenMaya
//! \brief OS functionality.  
/*!

 Methods for getting and setting environment variables, make
 directories etc.

  This class provides some standard Operating System functionality that
  is available from MEL.  These methods can be called instead of
  invoking MEL through the MGlobal class.

  NOTE: These methods are provided as a convenience.  It would be more
  efficient to call directly into the operating system than to use
  the methods of this class.
*/
class OPENMAYA_EXPORT MCommonSystemUtils
{
public:
	static MString getEnv( const MString &variable, MStatus *ResultStatus = NULL);
	static MStatus putEnv( const MString &variable, const MString &value );
	static MStatus makeDirectory( const MString &path );

BEGIN_NO_SCRIPT_SUPPORT:
	//!		NO SCRIPT SUPPORT
	static MStatus getEnv( const MString &variable, MString &result );
END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
	static const char* 	className();

};

#endif /* __cplusplus */
#endif /* _MCommonSystemUtils */
