#ifndef _MFnDynSweptGeometryData
#define _MFnDynSweptGeometryData
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnDynSweptGeometryData
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnData.h>

// ****************************************************************************
// DECLARATIONS

class MDynSweptLine;
class MDynSweptTriangle;

// ****************************************************************************
// CLASS DECLARATION (MFnDynSweptGeometryData)

//! \ingroup OpenMayaFX MFn
//! \brief Swept Geometry function set for dependency node data 
/*!
  MFnDynSweptGeometryData provides access to the MDynSweptLine and
  MDynSweptTriangle data for use in a user defined dependency graph node.
  The data is provided as an output from the geoConnector node and
  is primarily used to determine positional information over time.

  If a user written dependency node accepts MFnDynSweptGeometryData, then
  this class is used to extract data that comes from the geoConnector node.
  The MDataHandle::type method will return kDynSweptGeometry when data of
  this type is present. To access it, the MDataHandle::data() method is
  used to get an MObject for the data and this should then be used
  to initialize an instance of MFnDynSweptGeometryData.

  Important note: Users can create the data for connections but
  cannot produce the contents of the data as this is reserved
  for the Maya Dynamics internals.
*/
class OPENMAYAFX_EXPORT MFnDynSweptGeometryData : public MFnData
{

	declareMFn(MFnDynSweptGeometryData, MFnData);

public:
	int					lineCount( MStatus* ReturnStatus = NULL ) const;
	int					triangleCount( MStatus* ReturnStatus = NULL ) const;
	MDynSweptLine		sweptLine( int index,
							MStatus* ReturnStatus = NULL ) const;
	MDynSweptTriangle	sweptTriangle( int index,
							MStatus* ReturnStatus = NULL ) const;

	MObject				create( MStatus* ReturnStatus=NULL );

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnDynSweptGeometryData, MFnData );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnDynSweptGeometryData */
