#ifndef _MFnLatticeDeformer
#define _MFnLatticeDeformer
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnLatticeDeformer
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnDependencyNode.h>

// ****************************************************************************
// DECLARATIONS

class MDagPath;
class MObjectArray;

// ****************************************************************************
// CLASS DECLARATION (MFnLatticeDeformer)

//! \ingroup OpenMayaAnim MFn
//! \brief FFD lattice deformer function set
/*!
MFnLatticeDeformer is the function set for lattice deformers.  Lattice
deformers use FFDs to deform geometry.

The lattice deformer is actually a small network of dependency nodes in
the dependency graph.  This function set is provided to make
manipulation of the network easier.  The main deformer node should be
given to this function set as its object.

There are two lattices associated with a lattice deformer.  There is a
base lattice that defines the start position for the lattice.  The
second lattice is the version that is modified to deform the geometry.
The difference between the two lattices defines the deformation that is
applied to the geometry.

The base lattice is a very simple shape that only defines a box in
space.  The base lattice should be modified by using the standard DAG
transformation support.  The second deformable lattice has geometry
that can be modified using the MFnLattice function set.

For a piece of geometry to be modified by this deformer, the geometry
must be attached to the deformer (use addGeometry method) and the
geometry must be contained within the base lattice.  The resetLattice
method can be used to make the lattice resize to the bounding box of
the attached geometry.
*/ 
class OPENMAYAANIM_EXPORT MFnLatticeDeformer : public MFnDependencyNode
{
	declareMFn(MFnLatticeDeformer, MFnDependencyNode );

public:

	MObject create( unsigned int xDiv, unsigned int yDiv, unsigned int zDiv,
					MStatus * ReturnStatus = NULL );

	MStatus addGeometry( const MObject & object );
	MStatus removeGeometry( const MObject & object );

	MStatus getAffectedGeometry( MObjectArray & objects );

	MStatus getDivisions( unsigned int & x, unsigned int & y, unsigned int & z );
	MStatus setDivisions( unsigned int   x, unsigned int   y, unsigned int   z );

	MStatus resetLattice( bool centerLattice = false );

	MObject deformLattice( MStatus * ReturnStatus = NULL );
	MObject baseLattice( MStatus * ReturnStatus = NULL );

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnLatticeDeformer, MFnDependencyNode );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnLatticeDeformer */
