#ifndef _MFnRotateManip
#define _MFnRotateManip
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnRotateManip
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnBase.h>
#include <maya/MFnManip3D.h>
#include <maya/MObject.h>

// ****************************************************************************
// CLASS DECLARATION (MFnRotateManip)

//! \ingroup OpenMayaUI MFn
//! \brief RotateManip function set 
/*!
  This class provides access to the built-in Maya rotate manipulator.
  The manipulator consists of three constrained-axis rotation rings, a
  view rotation ring, as well as an invisible trackball that allows
  the user to rotate in arbitrary directions on the sphere.

  The manipulator provides data to the plugin through the rotation
  manipVal. The rotation value is a vector consisting of x, y, and z
  rotations. Rotations are measured from the initial rotation
  (usually <0,0,0>) of the manipulator.

  The manipulator can be configured either to display with an object
  (which must be a DAG node) or to display at an arbitrary point using
  the rotationCenter manipVal.
*/
class OPENMAYAUI_EXPORT MFnRotateManip : public MFnManip3D
{
	declareDagMFn(MFnRotateManip, MFnManip3D);

public:
	//! Manipulator rotation modes.
	enum RotateMode {
		kObjectSpace = 0,		//!< Object Space (default)
		kWorldSpace,			//!< World Space
		kGimbal					//!< Gimbal
	};

	MObject		create(MStatus *ReturnStatus = NULL);
	MObject		create(const MString &manipName,
					   const MString &rotationName,
					   MStatus *ReturnStatus = NULL);
	MStatus		connectToRotationPlug(const MPlug &rotationPlug);
	MStatus		connectToRotationCenterPlug(const MPlug &rotationCenterPlug);
	MStatus		setInitialRotation(const MEulerRotation& rotation);
	MStatus		displayWithNode(const MObject& node);
	MStatus		setRotateMode(RotateMode mode);
	RotateMode	rotateMode() const;
	MStatus		setSnapMode(bool snapEnabled);
	bool		isSnapModeOn() const;
	MStatus		setSnapIncrement(double snapInc);
	double		snapIncrement() const;
	unsigned int	rotationIndex(MStatus *ReturnStatus = NULL) const;
	unsigned int	rotationCenterIndex(MStatus *ReturnStatus = NULL) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareDagMFnConstConstructor(MFnRotateManip, MFnManip3D );

END_NO_SCRIPT_SUPPORT:

protected:
	// No protected members
private:
	// No private members
};

#endif /* __cplusplus */
#endif /* _MFnRotateManip */
