#ifndef _MFnVolumeLight
#define _MFnVolumeLight
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnVolumeLight
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MObject.h>
#include <maya/MStatus.h>
#include <maya/MFnPointLight.h>

// ****************************************************************************
// DECLARATIONS

class MRampAttribute;

// ****************************************************************************
// CLASS DECLARATION (MFnVolumeLight)

//! \ingroup OpenMaya MFn
//! \brief Manage volume Light dependency Nodes. 
/*!
 MFnVolumeLight facilitates creation and manipulation of dependency graph nodes
 representing voume lights.
*/
class OPENMAYA_EXPORT MFnVolumeLight : public MFnPointLight
{

	declareDagMFn(MFnVolumeLight, MFnPointLight);
public:
	//! Available shapes for a volume light.
	enum MLightShape
	{
		kBoxVolume,		//!< \nop
		kSphereVolume,		//!< \nop
		kCylinderVolume,	//!< \nop
		kConeVolume		//!< \nop
	};

	//! Direction that light travels.
	enum MLightDirection
	{
		/*!
		Light travels outwared from the center of a box- or
		sphere-shaped volume, and outward from the axis of a
		cylinder- or cone-shaped volume.
		*/
		kOutward,

		/*!
		Light travels inward toward the center of a box- or
		sphere-shaped volume, and inward toward the axis of a
		cylinder- or cone-shaped volume.
		*/
		kInward,

		/*!
		Light travels down the axis, like a directional
		light pointing in the negative Y direction.
		*/
		kDownAxis
	};

	MObject     create( bool UIvisible = true, MStatus * ReturnStatus = NULL );
	MObject     create( const MObject& parent, bool UIvisible = true,
				  bool wantTransform = false, MStatus * ReturnStatus = NULL );
	MFnVolumeLight::MLightShape  lightShape ( MStatus * ReturnStatus = NULL ) const;
	MStatus     setLightShape ( const MFnVolumeLight::MLightShape& light_shape);
	MFnVolumeLight::MLightDirection volumeLightDirection (MStatus * ReturnStatus = NULL) const;
	MStatus		setVolumeLightDirection (const MFnVolumeLight::MLightDirection& volume_light_direction);
	float		arc ( MStatus * ReturnStatus = NULL ) const;
	MStatus		setArc (const float& arc);
	float		coneEndRadius ( MStatus * ReturnStatus = NULL ) const;
	MStatus		setConeEndRadius (const float& cone_end_radius);
	bool		emitAmbient ( MStatus * ReturnStatus = NULL ) const;
	MStatus		setEmitAmbient (const bool& emit_ambient);
	MRampAttribute colorRamp (MStatus * ReturnStatus = NULL) const ;
	MRampAttribute penumbraRamp (MStatus * ReturnStatus = NULL) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareDagMFnConstConstructor( MFnVolumeLight, MFnPointLight );

	//! NO SCRIPT SUPPORT
	MObject     create( const MObject& parent, bool UIvisible = true,
						MStatus * ReturnStatus = NULL );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnVolumeLight */



