#ifndef _MFnWireDeformer
#define _MFnWireDeformer
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnWireDeformer
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnDependencyNode.h>
#include <maya/MPoint.h>

// ****************************************************************************
// DECLARATIONS

class MDagPath;
class MObjectArray;

// ****************************************************************************
// CLASS DECLARATION (MFnWireDeformer)

//! \ingroup OpenMayaAnim MFn
//! \brief wire deformer function set 
/*!
MFnWireDeformer is the function set for wire deformers.  Wire deformers modify
geometry based on its proximity to controlling wire curves.  As the wire
curves are modified, the parts of the geometry close to the curve will follow.

The wire deformer is actually a small network of dependency nodes in the
dependency graph.  This function set is provided to make manipulation of the
network easier.  The main deformer node should be given to this function set as
its object.
*/
class OPENMAYAANIM_EXPORT MFnWireDeformer : public MFnDependencyNode
{

	declareMFn(MFnWireDeformer, MFnDependencyNode );

public:

	MObject  create( MStatus * ReturnStatus = NULL );


	MStatus addGeometry( const MObject & object );
	MStatus removeGeometry( const MObject & object );
	MStatus getAffectedGeometry( MObjectArray & objects );

	unsigned int numWires( MStatus * ReturnStatus = NULL ) const;
	MStatus  addWire( const MObject & object );
	MObject  wire( unsigned int wireIndex, MStatus * ReturnStatus = NULL );
	float    wireDropOffDistance( unsigned int wireIndex,
								  MStatus * ReturnStatus = NULL ) const;
	MStatus  setWireDropOffDistance( unsigned int wireIndex, float dropOff );
	float    wireScale( unsigned int wireIndex,
								  MStatus * ReturnStatus = NULL ) const;
	MStatus  setWireScale( unsigned int wireIndex, float scale );
	MObject  holdingShape( unsigned int wireIndex,
						          MStatus * ReturnStatus = NULL ) const;
	MStatus  setHoldingShape( unsigned int wireIndex, MObject holdingCurve );

	float    envelope( MStatus * ReturnStatus = NULL ) const;
	MStatus  setEnvelope( float envelope );
	float    rotation( MStatus * ReturnStatus = NULL ) const;
	MStatus  setRotation( float rotation );
	float    localIntensity( MStatus * ReturnStatus = NULL ) const;
	MStatus  setLocalIntensity( float localIntensity );
	float    crossingEffect( MStatus * ReturnStatus = NULL ) const;
	MStatus  setCrossingEffect( float crossingEffect );

	unsigned int numDropoffLocators( unsigned int wireIndex,
								 MStatus * ReturnStatus = NULL ) const;
	MStatus  setDropoffLocator( unsigned int wireIndex, unsigned int locatorIndex,
						         float param, float percentage );
	MStatus  getDropoffLocator( unsigned int wireIndex, unsigned int locatorIndex,
						         float &param, float &percentage );

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnWireDeformer, MFnDependencyNode );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members

};

#endif /* __cplusplus */
#endif /* _MFnWireDeformer */
