#ifndef _MIffFile
#define _MIffFile
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MIffFile
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


class MString;
class MIffTag;
class MStatus;

// ****************************************************************************
// CLASS DECLARATION (MIffFile)

//! \ingroup OpenMaya
//! \brief Read file images stored on disk. 
/*!
	This class provides a simple C++ interface to the IFF i/o library
	(flib). A class called MIffTag is used to create the 4 byte tags
	that are used to distinguish the different block types within an
	IFF file.
*/
class OPENMAYA_EXPORT MIffFile
{
public:

					MIffFile();
					MIffFile(const MString &fileName);
					virtual ~MIffFile();
	MStatus			open(const MString & fileName);

	MStatus			close();

	bool			isActive() const;

	MStatus			beginReadGroup(MIffTag& id, MIffTag& type);

    MStatus			endReadGroup();

    const void *	getChunk(MIffTag& chunkTag, unsigned *byteCount);

	MStatus			beginGet(MIffTag& chunkTag, unsigned *byteCount);

    MStatus			endGet();

	int				get(void *buf, unsigned byteCount, MStatus *stat = NULL);

	MStatus			iffGetShort( short int& result );

	MStatus			iffGetInt( int& result );

	MStatus			iffGetFloat( float& result );

protected:
	// No protected members

private:
	static const char* className();

	void *_fileHandler;
};

#endif /* __cplusplus */
#endif /* _MIffFile */
