#ifndef _MIffTag
#define _MIffTag
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MIffTag
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MObject.h>
#include <maya/MString.h>
#include <maya/MTypes.h>

// ****************************************************************************
// CLASS DECLARATION (MIffTag)

//! \ingroup OpenMaya
//! \brief Encapsulates IFF's 4 character block structure. 
/*!
	Class MIffTag is used to create the 4 byte tags that are used to
	distinguish the different block types within an IFF file.
*/
class OPENMAYA_EXPORT MIffTag
{
public:
	MIffTag();

	MIffTag(unsigned char a, unsigned char b, unsigned char c, unsigned char d);

	MIffTag(unsigned int tag);

	~MIffTag();

	bool  operator==( const MIffTag& tag ) const;

	//! Marks the start of a group of data blocks.
	static const MIffTag kFORM;

	//! Defines an unsorted group of FORM, e.g. images or sounds.
    static const MIffTag kCAT;

	//! Defines a sorted group of FORM, e.g. sequence of images
    static const MIffTag kLIST;

	//! Marks the start of a group of data blocks containing
	//! properties shared between forms that are a part of a LIST
    static const MIffTag kPROP;

	//! Four byte aligned FORM block
	static const MIffTag kFOR4;

	//! Eight byte aligned FORM block
    static const MIffTag kFOR8;

	//! Four byte aligned CAT block
    static const MIffTag kCAT4;

	//! Eight byte aligned CAT block
    static const MIffTag kCAT8;

	//! Four byte aligned LIST block
    static const MIffTag kLIS4;

	//! Eight byte aligned LIST block
    static const MIffTag kLIS8;

	//! Four byte aligned PROP block
    static const MIffTag kPRO4;

	//! Eight byte aligned PROP block
    static const MIffTag kPRO8;

protected:
	// No protected members

private:
	friend class MIffFile;

	union {
		int			 _force_alignment;
		char		 f_data[4];
	};
};

#endif /* __cplusplus */
#endif /* _MIffTag */
