#ifndef _MItCurveCV
#define _MItCurveCV
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MItCurveCV
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnDagNode.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MPointArray;
class MDoubleArray;
class MVector;
class MPoint;
class MDagPath;
class MPtrBase;

// ****************************************************************************
// CLASS DECLARATION (MItCurveCV)

//! \ingroup OpenMaya
//! \brief Iterator for NURBS curve CVs. 
/*!
This class is the iterator class for NURBS curve control vertices (CVs).
The iteration can be for a given curve or for a group of CVs.

<b>Example:</b> Translates the CVs for a curve in the X direction (world space).

\code
    MItCurveCV* cvIter = new MItCurveCV( curve, &stat );
    MVector vector(1.0,0.0,0.0);

    if ( MStatus::kSuccess == stat ) {
        for ( ; !cvIter->isDone(); cvIter->next() )
        {
            cvIter->translateBy( vector, MSpace::kWorld );
        }
        cvIter->updateCurve();	// Tell curve is has been changed
    }
    else {
        cerr << "Error creating iterator!" << endl;
    }
\endcode
*/
class OPENMAYA_EXPORT MItCurveCV
{
public:
    MItCurveCV( MObject & curve, MStatus * ReturnStatus = NULL );
    MItCurveCV( const MDagPath & curve,
				MObject & component = MObject::kNullObj,
                MStatus * ReturnStatus = NULL );
    virtual ~MItCurveCV();
    bool        isDone( MStatus * ReturnStatus = NULL ) const;
    MStatus     next();
    MStatus     reset();
    MStatus     reset( MObject & curve );
    MStatus     reset( const MDagPath & curve,
						MObject & component = MObject::kNullObj );
    MPoint      position( MSpace::Space space = MSpace::kObject,
                          MStatus * ReturnStatus = NULL ) const;
    MStatus     setPosition( const MPoint & pt,
							 MSpace::Space space = MSpace::kObject );
    MStatus     translateBy( const MVector & vec,
							 MSpace::Space space = MSpace::kObject );
    int	    index( MStatus * ReturnStatus = NULL ) const;
	// Obsolete
	MObject		cv( MStatus * ReturnStatus = NULL ) const;
	MObject		currentItem( MStatus * ReturnStatus = NULL ) const;

	bool        hasHistoryOnCreate( MStatus * ReturnStatus = NULL ) const;
    MStatus     updateCurve();

protected:
// No protected members

private:
    static const char* className();
	inline void * updateGeomPtr() const;
    MPtrBase * f_shape;
    MPtrBase * f_geom;
    void *     f_path;
	void *     f_it;
};

#endif /* __cplusplus */
#endif /* _MItCurveCV */
