#ifndef _MObjectArray
#define _MObjectArray
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MObjectArray
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MObject.h>
#include <maya/MStatus.h>

// ****************************************************************************
// CLASS DECLARATION (MObjectArray)

//! \ingroup OpenMaya
//! \brief  Array of MObjects data type. 
/*!
  This class implements an array of MObjects.  Common convenience functions
  are available, and the implementation is compatible with the internal
  Maya implementation so that it can be passed efficiently between plugins
  and internal maya data structures.
*/
class OPENMAYA_EXPORT MObjectArray
{

public:
					MObjectArray();
					MObjectArray( const MObjectArray& other );
					MObjectArray( unsigned int initialSize,
								  const MObject &initialValue
								  = MObject::kNullObj );
					~MObjectArray();
 	const MObject&	operator[]( unsigned int index ) const;
 	MStatus			set( const MObject& element, unsigned int index );
	MStatus			setLength( unsigned int length );
 	unsigned int		length() const;
 	MStatus			remove( unsigned int index );
 	MStatus			insert( const MObject & element, unsigned int index );
 	MStatus			append( const MObject & element );
 	MStatus			clear();
	void			setSizeIncrement ( unsigned int newIncrement );
	unsigned int		sizeIncrement () const;

BEGIN_NO_SCRIPT_SUPPORT:

    //!	NO SCRIPT SUPPORT
	MObjectArray( const MObject src[], unsigned int count );

    //!	NO SCRIPT SUPPORT
	MStatus			get( MObject array[] ) const;

	//!	NO SCRIPT SUPPORT
 	MObject&		operator[]( unsigned int index );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
 	MObjectArray& operator = (const MObjectArray&);
 	void* fArray;
	static const char* className();
};

#endif /* __cplusplus */
#endif /* _MObjectArray */
