#ifndef _MPolyMessage
#define _MPolyMessage
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPolyMessage
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MMessage.h>
#include <maya/MString.h>

// ****************************************************************************
// DECLARATIONS

class MUintArray;
class MObject;

// ****************************************************************************
// CLASS DECLARATION (MPolyMessage)

//! \ingroup OpenMaya
//! \brief Polygon component id change messages. 
/*!
	This class is used to register callbacks for poly component
	id modification messages.

	There is 1 add callback method which will add callbacks for the
	following messages:

		\li <b>vertex component id modified</b>
		\li <b>edge component id modified</b>
		\li <b>face component id modified</b>

    To remove a callback use MMessage::removeCallback.
	All callbacks that are registered by a plug-in must be removed by that
	plug-in when it is unloaded. Failure to do so will result in a fatal error.
*/
class OPENMAYA_EXPORT MPolyMessage : public MMessage
{
public:
	//! Values passed in addPolyComponentIdChangeCallback's
	//! "wantIdModifications" array to indicate which component
	//! id changes should trigger the callback.
	enum
	{
		kVertexIndex = 0,	//!< vertex component id changed
		kEdgeIndex = 1,		//!< edge component id changed
		kFaceIndex = 2,		//!< face component id changed
		kLastErrorIndex = 3	//!< \nop
	};

	static MCallbackId	addPolyComponentIdChangedCallback (
								MObject& node,
								bool wantIdModifications[],
								unsigned int count,
								MMessage::MComponentFunction func,
								void * clientData = NULL,
								MStatus * ReturnStatus = NULL);

	static MCallbackId	addPolyTopologyChangedCallback (
								MObject& node,
								MMessage::MNodeFunction func,
								void * clientData = NULL,
								MStatus * ReturnStatus = NULL);

	static unsigned int deletedId( void );

private:
	static const char* className();
};

#endif /* __cplusplus */
#endif /* _MPolyMessage */
