#ifndef __MPxUITableControl_h
#define __MPxUITableControl_h
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxUITableControl
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES

#include <maya/MPxUIControl.h>

// ****************************************************************************
// DECLARATIONS

class MStatus;
class MPxControlCommand;
class MString;

// ****************************************************************************
// CLASS DECLARATION (MPxUITableControl)

//! \ingroup OpenMayaUI MPx
//! \brief Base class for creating new spreadsheet controls.
/*!
MPxUITableControl is the base class for creating new spreadsheet like
interfaces.  Every UI control has an associated command that is
'in-charge' of that control.  Therefore, when creating a new table
control, you will need to create an associated
MPxControlCommand. Please refer to the MPxControlCommand documentation
for details on how to use these class together.

At a minimum, when creating a new table control, you must overload
getCell( ... ).  Other methods available for overloading are getLabel(...),
allowEdit( ... ), allowSelection( ... ), and collapseOrExpandRow( ... ).
*/
class OPENMAYAUI_EXPORT MPxUITableControl : public MPxUIControl
{
public:
	MPxUITableControl				( MPxControlCommand & );

	virtual ~MPxUITableControl		();

	//! Types of labels available in the control.
	enum MLabelType {
		kNoLabel,	//!< \nop
		kRowLabel,	//!< \nop
		kColumnLabel,	//!< \nop
		kAllLabels	//!< \nop
	};

	MStatus				redrawLabels( MLabelType lt = kAllLabels );

	MStatus				redrawCells();

	MStatus				addToSelection( unsigned int row, unsigned int col );

	MStatus				removeFromSelection( unsigned int row,
											 unsigned int column );

	MStatus				clearSelection( );

	MStatus				setSelection( unsigned int row, unsigned int column );

	MStatus				setSelection( unsigned int firstRow,
									  unsigned int lastRow,
									  unsigned int firstCol,
									  unsigned int lastCol );

	MStatus				setNumberOfRows( unsigned int count );

	unsigned int		numberOfRows( MStatus *ReturnStatus = NULL );

	MStatus				setNumberOfColumns( unsigned int count );

	unsigned int		numberOfColumns( MStatus *ReturnStatus = NULL ) const;


	bool				suspendUpdates( bool update, MStatus *ReturnStatue = NULL );

	bool				isSelected( unsigned int row, unsigned int col,
									MStatus *status = NULL );

	virtual bool		collapseOrExpandRow( unsigned int row );


protected:
	virtual MString		cellString( unsigned int r, unsigned int c, bool &ValidCell);
	virtual MString		labelString( MLabelType labelType, unsigned int n);

//BEGIN_NO_SCRIPT_SUPPORT:
	//!     NO SCRIPT SUPPORT
	virtual bool		getCell( unsigned int r, unsigned int c, MString &value );
	//!     NO SCRIPT SUPPORT
	virtual void		getLabel( MLabelType labelType, unsigned int n, MString &value );
//END_NO_SCRIPT_SUPPORT:

	virtual bool		allowEdit( ) const ;

	virtual bool		allowSelection( int top, int left, int bottom, int right );

private:
	MPxUITableControl();
	MPxUITableControl( const MPxUITableControl & );
	MPxUITableControl & operator=( const MPxUITableControl & );

	const char * className		() const;

	friend class MPxControlCommand;

	void *		instance;
};

#endif /* _cplusplus */
#endif /* MPxUITableControl */

