#ifndef _MRichSelection
#define _MRichSelection
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MRichSelection
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MSelectionList;
class MMatrix;
class MDagPath;
class MPlane;

// ****************************************************************************
// CLASS DECLARATION (MRichSelection)

//! \ingroup OpenMaya
//! \brief Selection list supporting soft selection and symmetry. 
/*!
This class implements a selection list that support soft selection and symmetry.

The rich selection is split into two halves: the "normal" side, and an optional
symmetric component. Components on both sides can include weight data which is
used to specify both the amount of influence and the proximity to the centre of
symmetry. 

In addition to the selected objects, the rich selection also includes information
about the axis of symmetry so that operations can determine how to process any
symmetric selection (e.g. reflect transformations, etc).
*/
class OPENMAYA_EXPORT MRichSelection
{
public:

	MRichSelection();
	MRichSelection( const MRichSelection & src );

	virtual ~MRichSelection();

	MStatus		getSelection( MSelectionList& selection) const;
	MStatus		getSymmetry( MSelectionList& symmetry) const;
	MStatus		getSymmetryMatrix( MMatrix& symmetryMatrix, MSpace::Space& space) const;
	MStatus		getSymmetryMatrix( const MDagPath& path, MSpace::Space space, MMatrix& symmetryMatrix) const;
	MStatus		getSymmetryPlane( const MDagPath& path, MSpace::Space space, MPlane& plane) const;

	MStatus		clear();

protected:
// No protected members

private:
	friend class MGlobal;
	MRichSelection( void * );
	void		setData( void *, bool);
	static const char* className();
	void *		selection_data;
	bool		owns_data;
};

#endif /* __cplusplus */
#endif /* _MRichSelection */
