#ifndef _MSelectionList
#define _MSelectionList
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MSelectionList
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MDagPath;
class MString;
class MStringArray;
class MPlug;

// ****************************************************************************
// CLASS DECLARATION (MSelectionList)

//! \ingroup OpenMaya
//! \brief A list of MObjects. 
/*!
This class implements a list of MObjects.

The global selection list is a special case where the objects on the list
are also active objects in Maya.

Besides the usual list methods, this class also provides an add method
which retrieves objects from Maya, such as dependency nodes, by name.
*/
class OPENMAYA_EXPORT MSelectionList
{
public:
	//! Specifies how to merge objects with those already in the list.
	enum MergeStrategy {
		//! If the object is not already on the list, add it.
		kMergeNormal=0,

		//! Exclusive OR: if the object is already on the list,
		//! remove it, otherwise add it.
		kXORWithList,

		//! Remove the object from the list.
		kRemoveFromList
	};

	MSelectionList();
	MSelectionList( const MSelectionList & src );

	virtual ~MSelectionList();

	MStatus			clear	();
	bool			isEmpty	( MStatus * ReturnStatus = NULL ) const;
	unsigned int	length	( MStatus * ReturnStatus = NULL ) const;
	MStatus		    getDependNode ( unsigned int index, MObject &depNode ) const;
	MStatus		    getDagPath    ( unsigned int index, MDagPath &dagPath,
								    MObject &component = MObject::kNullObj
									) const;
	MStatus		    getPlug	( unsigned int index, MPlug &plug ) const;

	MStatus			add		( const MObject & object,
							  const bool mergeWithExisting = false );
	MStatus			add		( const MDagPath & object,
							  const MObject & component = MObject::kNullObj,
							  const bool mergeWithExisting = false );
	MStatus         add     ( const MString & matchString );

	MStatus			add		( const MPlug & plug,
							  const bool mergeWithExisting = false );

	MStatus			remove	( unsigned int index );
	MStatus			replace	( unsigned int index, const MObject & item );
	MStatus			replace	( unsigned int index,
							  const MDagPath& item,
							  const MObject& component = MObject::kNullObj );
	MStatus			replace	( unsigned int index, const MPlug & plug );

	bool			hasItem ( const MObject & item,
							  MStatus* ReturnStatus = NULL ) const;
	bool			hasItem ( const MDagPath& item,
							  const MObject& component = MObject::kNullObj,
							  MStatus* ReturnStatus = NULL ) const;
	bool			hasItem ( const MPlug & plug,
							  MStatus* ReturnStatus = NULL ) const;

	bool			hasItemPartly ( const MDagPath& item,
									const MObject& component,
									MStatus* ReturnStatus = NULL ) const;
	MStatus			toggle ( const MDagPath& item,
							 const MObject& component = MObject::kNullObj );

	MSelectionList& operator =( const MSelectionList& other );

	MStatus			merge( const MSelectionList& other,
						   const MergeStrategy strategy = kMergeNormal );
	MStatus			merge( const MDagPath& object,
						   const MObject& component = MObject::kNullObj,
						   const MergeStrategy strategy = kMergeNormal );

	MStatus         getSelectionStrings( MStringArray & array ) const;
	MStatus         getSelectionStrings( unsigned int index,
										 MStringArray & array ) const;


protected:
// No protected members

private:
	MSelectionList( void * );
	static const char* className();
	void merge( const void*, const MergeStrategy strategy );
	void * list_data;
	bool fOwn;
};

#endif /* __cplusplus */
#endif /* _MSelectionList */
