#ifndef _MAnimCurveChange
#define _MAnimCurveChange
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MAnimCurveChange
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// CLASS DECLARATION (MAnimCurveChange)

//! \ingroup OpenMayaAnim
//! \brief  Anim Curve Change Cache
/*!
  Caching of the undo and redo information in a Anim Curve Change cache is
  required primarily to support interactive editing of Anim Curves in the UI.

  Anim Curve Change caches are used as persistent storage for information
  concerning changes to Anim Curve Nodes.

  When invoked with a valid Anim Curve change parameter, the remove keyframe and
  add keyframe methods of the Anim Curve Function Set (MFnAnimCurve::remove()
  and MFnAnimCurve::addKeyframe(), respectively) cache the change information
  in the Anim Curve Change cache so that the caller can undo and redo the
  changes as required.

  If the same cache is used for a series of Anim Curve edit operations, then the
  cache maintains an undo/redo queue which allows all changes in the series to be
  undone or redone.  If selective undo/redo is required, then a different Anim
  Curve Change cache is required for each edit.

  Use Anim Curve Change caches in conjunction with the Anim Curve Function
  Set (MFnAnimCurve) to perform undoable and redoable edits on Anim Curves.
*/
class OPENMAYAANIM_EXPORT MAnimCurveChange
{

public:
	MAnimCurveChange( MStatus * ReturnStatus = NULL );
	~MAnimCurveChange();
	MStatus undoIt();
	MStatus redoIt();

protected:
// No protected members

private:
	static const char* className();
	void*		 data;
};

#endif /* __cplusplus */
#endif /* _MAnimCurveChange */
