#ifndef _MComputation
#define _MComputation
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MComputation
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>

// ****************************************************************************
// CLASS DECLARATION (MComputation)

//! \ingroup OpenMaya
//! \brief Interupt monitor for long computations. 
/*!
An MComputation allows long computations to check for user interrupts.  It is
very simple to use.  Create a new <i>MComputation</i> object and call the
<i>beginComputation</i> method at the beginning of the computation and call
the <i>endComputation</i> method when you finish.  Then, during the computation,
use the <i>isInterruptRequested</i> method to check if the user has requested
that the computation terminate.

<b>Example:</b> (of a simple traversal)

\code
    MComputation computation;
    computation.beginComputation();
    for (int i= 1; i<1000; i++) {
        Computation();  // Some expensive operation
        if  (computation.isInterruptRequested()) break ;
    }
    computation.endComputation();
\endcode
*/
class OPENMAYA_EXPORT MComputation {

public:
			MComputation();
	virtual	~MComputation();
    void	beginComputation();
    bool	isInterruptRequested();
    void	endComputation();

protected:
// No protected members

private:
    const char* className() const;
	void *f_data;
};

#endif /* __cplusplus */
#endif /* _MComputation */
