#ifndef _MDGContext
#define _MDGContext
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MDGContext
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// DECLARATIONS

class MObject;
class MTime;

// ****************************************************************************
// CLASS DECLARATION (MDGContext)

//! \ingroup OpenMaya
//! \brief Dependency graph (DG) context class. 
/*!

  Control the way in which dependency nodes are evaluated.

  DG contexts are used to define the way in which a dependency node is
  going to be evaluated. Examples of such contexts include "normal",
  "at a given time, "for a specific instance", etc.

  MDGContext is mainly used in two places; within methods that trigger
  evaluations, to define what kind of evaluate is being requested, and
  within data blocks (MDataBlock), to identify how the data was
  created.
*/
class OPENMAYA_EXPORT MDGContext
{
public:

	// Normal
	MDGContext( );

	// Timed
	MDGContext( const MTime & when );

	MDGContext( const MDGContext& in );

	~MDGContext();



    // Method for determining whether the context is the "normal" one,
	// ie. the one used for normal evaluation
	bool     	isNormal( MStatus * ReturnStatus = NULL ) const;

	MStatus 	getTime( MTime & ) const;

	MDGContext&	operator =( const MDGContext& other );


	// Default context "Normal"
	static		MDGContext	fsNormal;


protected:
// No protected members

private:
	const void * data;
	bool fOwn;
	friend class MPlug;
	friend class MDataBlock;
	const char* className() const;
	MDGContext( const void* );
	MDGContext( const void*, bool own );
};

#endif /* __cplusplus */
#endif /* _MDGContext */
