#ifndef _MDrawInfo
#define _MDrawInfo
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MDrawInfo
//
// ****************************************************************************
//
#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>
#include <maya/MObject.h>
#include <maya/M3dView.h>
#include <maya/MDrawRequest.h>

// ****************************************************************************
// DECLARATIONS

class MSelectionMask;
class MSelectionTypeSet;
class MPoint;
class MPointArray;
class MVector;
class MSelectionList;
class MMatrix;

// ****************************************************************************
// CLASS DECLARATION (MDrawInfo)

//! \ingroup OpenMayaUI
//! \brief Drawing state used in the draw methods of MPxSurfaceShapeUI
/*!
This class is used by the getDrawRequests method of MPxSurfaceShapeUI
to specify the current object drawing state for a user defined shape.

This getPrototype method is used to construct a draw request object
based on the current draw state for the object.

See MDrawRequest for more information.
*/
class OPENMAYAUI_EXPORT MDrawInfo
{
public:
	MDrawInfo();
	MDrawInfo( const MDrawInfo& in );
	virtual ~MDrawInfo();


	// This method returns a partially filled in MDrawRequest
	MDrawRequest			getPrototype(
								const MPxSurfaceShapeUI& drawHandler ) const;

	// Only really need camera path here
	M3dView  				view() const;

	// path to object to draw
	const MDagPath 			multiPath () const;

	// projection (camera) matrix
	const MMatrix 			projectionMatrix() const;

	// world space inclusive matrix
	const MMatrix 			inclusiveMatrix() const;

	// display appearance (this may change during traversal)
	M3dView::DisplayStyle	displayStyle() const;

	// display status of object to draw
	M3dView::DisplayStatus	displayStatus() const;

	// display objects
	bool objectDisplayStatus( M3dView::DisplayObjects ) const;

	bool					inSelect() const;
	bool					inUserInteraction() const;
	///
	bool					userChangingViewContext() const;
	///
	bool					completelyInside() const;

	// convenience to test if component can be drawn
	bool					canDrawComponent( bool isDisplayOn,
									const MSelectionMask & compMask ) const;

protected:
	void*	 fData;

private:
	const char*	 className() const;
    MDrawInfo( void* in );
};

#endif /* __cplusplus */
#endif /* _MDrawInfo */
