#ifndef _MDynSweptLine
#define _MDynSweptLine
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All 
// rights reserved.
// 
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors,  which is protected by U.S. and Canadian federal copyright law 
// and by international treaties.
// 
// The Data may not be disclosed or distributed to third parties or be 
// copied or duplicated, in whole or in part, without the prior written 
// consent of Autodesk.
// 
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the following 
// disclaimer, must be included in all copies of the Software, in whole 
// or in part, and all derivative works of the Software, unless such copies 
// or derivative works are solely in the form of machine-executable object 
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, 
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO 
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST 
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR 
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS 
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES. 
// ==========================================================================
//+
//
// CLASS:    MDynSweptLine
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// DECLARATIONS

class MVector;

// ****************************************************************************
// CLASS DECLARATION (MDynSweptLine)

//! \ingroup OpenMayaFX
//! \brief Class for evaluating curve segments as lines over time. 
/*!
	A MDynSweptLine provides access to a curve segment defined as a line.
	It can only be accessed with the MFnDynSweptGeometryData class
	that is provided as an output from the geoConnector node.

	The class provides parametric time evaluation for a curve.
	Time is in the range 0 to 1, where 1 represents the current frame and 0
	represents the previous frame. In this way you can get interpolated
	values of a curve in motion.
*/
class OPENMAYAFX_EXPORT MDynSweptLine
{
public:
					MDynSweptLine();
					~MDynSweptLine();

	// Time-Dependent Access Methods
	//
	MVector			vertex( int vertexId, double t = 1.0 );
	MVector			normal( double x, double y, double z, double t = 1.0 );
	MVector			tangent( double t = 1.0 );
	double			length( double t = 1.0 );

protected:
// No protected members

private:
	static const char* className();
	MDynSweptLine( void* );
	void * fData;
};

#endif /* __cplusplus */
#endif /* _MDynSweptLine */
