#ifndef _MEulerRotation
#define _MEulerRotation
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MEulerRotation
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>
#include <maya/MTransformationMatrix.h>
#include <maya/MIOStreamFwd.h>

// ****************************************************************************
// DECLARATIONS

class MMatrix;
class MQuaternion;
#define kEulerRotationEpsilon 1.0e-10

// ****************************************************************************
// CLASS DECLARATION (MEulerRotation)

//! \ingroup OpenMaya
//! \brief Euler Rotation Math. 
/*!
This class provides methods for working with euler angle rotations.
Euler angles are described by rotations in radians around the x, y, and z axes,
and the order in which those rotations occur.
*/
class OPENMAYA_EXPORT MEulerRotation
{
public:
	//! Valid rotaton orders.
	enum RotationOrder {
		kXYZ,	//!< \nop
		kYZX,	//!< \nop
		kZXY,	//!< \nop
		kXZY,	//!< \nop
		kYXZ,	//!< \nop
		kZYX	//!< \nop
	};

						MEulerRotation();
						MEulerRotation(const MEulerRotation &src);
						MEulerRotation(const MVector &v,
									   RotationOrder ord = kXYZ);
						MEulerRotation(double xx, double yy, double zz,
									   RotationOrder ord = kXYZ);
						~MEulerRotation();
	MEulerRotation &	operator=(const MEulerRotation &src);
 	MEulerRotation &	operator=(const MQuaternion &q);
 	MEulerRotation &	operator=(const MMatrix &m);
 	MEulerRotation &	operator=(const MVector &v);
	MEulerRotation &	setValue(const MVector &v,
								 RotationOrder ord = kXYZ);
	MEulerRotation &	setValue(double xx, double yy, double zz,
								 RotationOrder ord = kXYZ);
	MQuaternion			asQuaternion() const;
	MMatrix				asMatrix() const;
 	MVector				asVector() const;
	double				operator[](unsigned int i) const;
 	MEulerRotation   	operator+(const MEulerRotation &other) const;
	MEulerRotation &	operator+=(const MEulerRotation &other);
 	MEulerRotation   	operator-(const MEulerRotation &other) const;
	MEulerRotation &	operator-=(const MEulerRotation &other);
 	MEulerRotation   	operator-() const;
	MEulerRotation		operator*(const MEulerRotation &other) const;
	MEulerRotation		operator*(const MQuaternion &other) const;
	MEulerRotation		operator*(double other) const;
	MEulerRotation &	operator*=(const MEulerRotation &other);
	MEulerRotation &	operator*=(const MQuaternion &other);
	MEulerRotation &	operator*=(double other);
 	bool           		operator==(const MEulerRotation &other) const;
 	bool          		operator!=(const MEulerRotation &other) const;
 	bool          		isEquivalent(const MEulerRotation &other,
									 double tolerance = kEulerRotationEpsilon)
		                             const;
 	bool          		isZero(double tolerance = kEulerRotationEpsilon) const;
	MEulerRotation &	incrementalRotateBy(const MVector &axis,
											double angle);
	MEulerRotation		inverse() const;
	MEulerRotation &	invertIt();
	MEulerRotation		reorder(RotationOrder ord) const;
	MEulerRotation &	reorderIt(RotationOrder ord);
	MEulerRotation		bound() const;
	MEulerRotation &	boundIt(const MEulerRotation &src);
	MEulerRotation &	boundIt();
	MEulerRotation		alternateSolution() const;
	MEulerRotation &	setToAlternateSolution(const MEulerRotation &src);
	MEulerRotation &	setToAlternateSolution();
	MEulerRotation		closestSolution(const MEulerRotation &dst) const;
	MEulerRotation &	setToClosestSolution(const MEulerRotation &src,
											 const MEulerRotation &dst);
	MEulerRotation &	setToClosestSolution(const MEulerRotation &dst);
	MEulerRotation		closestCut(const MEulerRotation &dst) const;
	MEulerRotation &	setToClosestCut(const MEulerRotation &src,
										const MEulerRotation &dst);
	MEulerRotation &	setToClosestCut(const MEulerRotation &dst);
	static MEulerRotation decompose(const MMatrix &matrix, RotationOrder ord);

BEGIN_NO_SCRIPT_SUPPORT:

	//!	NO SCRIPT SUPPORT
	double &			operator[](unsigned int i);

	//!	NO SCRIPT SUPPORT
	static MEulerRotation bound(const MEulerRotation &src);
	//!	NO SCRIPT SUPPORT
	static MEulerRotation alternateSolution(const MEulerRotation &src);
	//!	NO SCRIPT SUPPORT
	static MEulerRotation closestSolution(const MEulerRotation &src,
										  const MEulerRotation &dst);
	//!	NO SCRIPT SUPPORT
	static MEulerRotation closestCut(const MEulerRotation &src,
									 const MEulerRotation &dst);

	//!	NO SCRIPT SUPPORT
 	friend OPENMAYA_EXPORT MEulerRotation operator*(double scale,
													const MEulerRotation
													    &other);
	//!	NO SCRIPT SUPPORT
	friend OPENMAYA_EXPORT std::ostream &operator<<(std::ostream &os,
											   const MEulerRotation &rotation);


END_NO_SCRIPT_SUPPORT:

	//! The euler rotation identity.  The rotation order is XYZ.
	static const MEulerRotation identity;

	//! The x component of the euler rotation in radians
	double x;
	//! The y component of the euler rotation in radians
	double y;
	//! The z component of the euler rotation in radians
	double z;
	//! The rotation order of the euler rotation
	RotationOrder order;
#if defined(LINUX)
	char			_padding[4];		// Pad out sizeof class
#endif

protected:
	// No protected members

private:
	// No private members
};

#ifdef WANT_GCC41_FRIEND
MEulerRotation operator*(double scale, const MEulerRotation &other);
#endif

#endif /* __cplusplus */
#endif /* _MEulerRotation */
