#ifndef _MFnCompoundAttribute
#define _MFnCompoundAttribute
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnCompoundAttribute
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnAttribute.h>

// ****************************************************************************
// DECLARATIONS

class MString;
class MStringArray;

// ****************************************************************************
// CLASS DECLARATION (MFnCompoundAttribute)

//! \ingroup OpenMaya MFn
//! \brief Compound attribute function set. 
/*!
   MFnCompoundAttribute is the function set for compound dependency node
   attributes.

   Compound attributes allow the grouping of related attributes into a larger
   unit.  It is possible to connect to a compound attribute as a whole, or
   to any of the individual children.

   For example, the three attributes RED, GREEN, and BLUE could be grouped into
   a compound attribute of type COLOR.  It is then possible to connect two
   COLOR attributes together.  This removes the need to connect each child
   explicitly.

   A second use for compound attributes is when there are multi attributes that
   relate to each other on an element-by-element basis.  An example of this
   is the weighted matrix node that has a multi attribute with matrices that
   must be matched with the multi attribute that provides the weights for each
   matrix.
*/
class OPENMAYA_EXPORT MFnCompoundAttribute : public MFnAttribute
{
	declareMFn(MFnCompoundAttribute, MFnAttribute);

public:
	MObject 	create( const MString& full,
						const MString& brief,
						MStatus* ReturnStatus = NULL );
	MStatus		addChild( const MObject & child );
	MStatus		removeChild( const MObject & child );
	unsigned int	numChildren( MStatus* ReturnStatus = NULL ) const;
	MObject 	child( unsigned int index, MStatus* ReturnStatus = NULL ) const;
	MStatus		getAddAttrCmds(
					MStringArray&	cmds,
					bool			useLongNames = false
				) const;

BEGIN_NO_SCRIPT_SUPPORT:

	//!	NO SCRIPT SUPPORT
 	declareMFnConstConstructor( MFnCompoundAttribute, MFnAttribute );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnCompoundAttribute */
