#ifndef _MFnGenericAttribute
#define _MFnGenericAttribute
//
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnGenericAttribute
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnAttribute.h>
#include <maya/MFnData.h>
#include <maya/MFnNumericData.h>

class MTypeId;
class MString;

// ****************************************************************************
// CLASS DECLARATION (MFnGenericAttribute)

//! \ingroup OpenMaya MFn
//! \brief Generic attribute function set. 
/*!
  MFnGenericAttribute is a function set for attributes that can accept
  several types of data. A generic attribute is similar to a typed
  attribute (MFnTypedAttribute) except that it has a list of types
  that it considers valid.

  If the attribute will only take one type of data then it is more
  efficient to use one of the other attribute function sets such as
  MFnTypedAttribute or MFnNumericAttribute.
*/
class OPENMAYA_EXPORT MFnGenericAttribute : public MFnAttribute
{
	declareMFn(MFnGenericAttribute, MFnAttribute);

public:
	MObject 	create( const MString& full,
						const MString& brief,
						MStatus* ReturnStatus = NULL );
	MStatus		addDataAccept( MFnData::Type newType );
	MStatus		addNumericDataAccept( MFnNumericData::Type newType );
	MStatus		addAccept( const MTypeId& id );
	MStatus		removeDataAccept( MFnData::Type oldType );
	MStatus		removeNumericDataAccept( MFnNumericData::Type oldType );
	MStatus		removeAccept( const MTypeId& id );

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnGenericAttribute, MFnAttribute );

    //!	Obsolete & no script support
	MStatus		addAccept( MFnData::Type newType );
    //!	Obsolete & no script support
	MStatus		addAccept( MFnNumericData::Type newType );

    //!	Obsolete & no script support
	MStatus		removeAccept( MFnData::Type oldType );
    //!	Obsolete & no script support
	MStatus		removeAccept( MFnNumericData::Type oldType );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members
private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnGenericAttribute */
