#ifndef _MFnIkHandle
#define _MFnIkHandle
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnIkHandle
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnTransform.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MObjectArray;

// ****************************************************************************
// CLASS DECLARATION (MFnIkHandle)

//! \ingroup OpenMayaAnim MFn
//! \brief Function set for inverse kinematics (IK) handles 
/*!
	This is the function set for inverse kinematics (IK) handles.
	An ik handle specifies the joints in a skeleton that are effected
	by an attached ik solver.
*/
class OPENMAYAANIM_EXPORT MFnIkHandle : public MFnTransform
{
	declareDagMFn( MFnIkHandle, MFn::kHandle );

public:
	//! Specifies a handle's stickiness when the skeleton is being manipulated interactively.
	enum Stickiness {
		kStickyOff,	//!< Handle will move with skeleton's root.
		kStickyOn,	//!< Handle will try to stay where it is.
		kSuperSticky	//!< Not used.
    };
	MObject   create( MDagPath& startJoint,
	                  MDagPath& effector,
					  MStatus * ReturnStatus = NULL );
	MStatus   getStartJoint( MDagPath &jointPath );
	MStatus   setStartJoint( const MDagPath &jointPath );
	MStatus   getEffector( MDagPath &effectorPath );
	MStatus   setEffector( const MDagPath &effectorPath );
	MStatus   setStartJointAndEffector( const MDagPath &jointPath,
										const MDagPath &effectorPath );
	unsigned int  priority( MStatus * ReturnStatus = NULL );
	MStatus   setPriority( unsigned int priority );
	Stickiness stickiness( MStatus * ReturnStatus = NULL );
	MStatus   setStickiness( Stickiness stickiness );
	double    weight( MStatus * ReturnStatus = NULL );
	MStatus   setWeight( double weight );
	double    poWeight( MStatus * ReturnStatus = NULL );
	MStatus   setPOWeight( double weight );
	MObject   solver( MStatus * ReturnStatus = NULL );
	MStatus   setSolver( const MObject &solver );
	MStatus   setSolver( const MString & solverName );

BEGIN_NO_SCRIPT_SUPPORT:

 	declareDagMFnConstConstructor( MFnIkHandle, MFn::kHandle );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnIkHandle */
