#ifndef _MFnIkJoint
#define _MFnIkJoint
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnIkJoint
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnTransform.h>
#include <maya/MTransformationMatrix.h>
#include <maya/MObject.h>

// ****************************************************************************
// CLASS DECLARATION (MFnIkJoint)

//! \ingroup OpenMayaAnim MFn
//! \brief Function set for joints 
/*!
	This is the function set for joints.

	The transformation matrix for a joint node is below.


	\li matrix = [S] * [RO] * [R] * [JO] * [IS] * [T]


	(where '*' denotes matrix multiplication).

	These matrices are defined as follows:


	\li <b>[S]</b> : scale
	\li <b>[RO]</b> : rotateOrient (attribute name is rotateAxis)
	\li <b>[R]</b> : rotate
	\li <b>[JO]</b> : jointOrient
	\li <b>[IS]</b> : parentScaleInverse
	\li <b>[T]</b> : translate


	The methods to get the value of these matrices are:


	\li <b>[S]</b> : getScale
	\li <b>[RO]</b> : getScaleOrientation
	\li <b>[R]</b> : getRotation
	\li <b>[JO]</b> : getOrientation
	\li <b>[IS]</b> : (the inverse of the getScale on the parent transformation matrix)
	\li <b>[T]</b> : translation
*/
class OPENMAYAANIM_EXPORT MFnIkJoint : public MFnTransform
{
	declareDagMFn( MFnIkJoint, MFn::kJoint );

public:
	enum Axis {
		kXAxis,
		kYAxis,
		kZAxis,
		kNone };
	MObject create( MObject parent = MObject::kNullObj,
					MStatus * ReturnStatus = NULL );
	MStatus getOrientation( MQuaternion &quaternion ) const;
	MStatus setOrientation( const MQuaternion &quaternion );
	MStatus getOrientation( MEulerRotation &rotation ) const;
	MStatus setOrientation( const MEulerRotation &rotation );
	MStatus getOrientation( double rotation[3],
							MTransformationMatrix::RotationOrder &order )
		                    const;
	MStatus setOrientation( const double rotation[3],
							MTransformationMatrix::RotationOrder order );
	MStatus getScaleOrientation( MQuaternion &quaternion ) const;
	MStatus setScaleOrientation( const MQuaternion &quaternion );
	MStatus getScaleOrientation( double rotation[3],
								 MTransformationMatrix::RotationOrder &order )
		                         const;
	MStatus setScaleOrientation( const double rotation[3],
								 MTransformationMatrix::RotationOrder order );
	MStatus getSegmentScale( double scale[3] ) const;
	MStatus setSegmentScale( const double scale[3] );
	MStatus getStiffness( double stiffness[3] ) const;
	MStatus setStiffness( const double stiffness[3] );
	MStatus getPreferedAngle( double rotation[3] ) const;
	MStatus setPreferedAngle( const double rotation[3] );
	MStatus getDegreesOfFreedom( bool &freeInX, bool &freeInY,
								 bool &freeInZ ) const;
	MStatus setDegreesOfFreedom( bool freeInX, bool freeInY,
								 bool freeInZ );
	double  minRotateDampXRange( MStatus * ReturnStatus = NULL ) const;
	double  minRotateDampYRange( MStatus * ReturnStatus = NULL ) const;
	double  minRotateDampZRange( MStatus * ReturnStatus = NULL ) const;
	double  maxRotateDampXRange( MStatus * ReturnStatus = NULL ) const;
	double  maxRotateDampYRange( MStatus * ReturnStatus = NULL ) const;
	double  maxRotateDampZRange( MStatus * ReturnStatus = NULL ) const;
	MStatus setMinRotateDampXRange( double angle );
	MStatus setMinRotateDampYRange( double angle );
	MStatus setMinRotateDampZRange( double angle );
	MStatus setMaxRotateDampXRange( double angle );
	MStatus setMaxRotateDampYRange( double angle );
	MStatus setMaxRotateDampZRange( double angle );
	double  minRotateDampXStrength( MStatus * ReturnStatus = NULL ) const;
	double  minRotateDampYStrength( MStatus * ReturnStatus = NULL ) const;
	double  minRotateDampZStrength( MStatus * ReturnStatus = NULL ) const;
	double  maxRotateDampXStrength( MStatus * ReturnStatus = NULL ) const;
	double  maxRotateDampYStrength( MStatus * ReturnStatus = NULL ) const;
	double  maxRotateDampZStrength( MStatus * ReturnStatus = NULL ) const;
	MStatus setMinRotateDampXStrength( double angle );
	MStatus setMinRotateDampYStrength( double angle );
	MStatus setMinRotateDampZStrength( double angle );
	MStatus setMaxRotateDampXStrength( double angle );
	MStatus setMaxRotateDampYStrength( double angle );
	MStatus setMaxRotateDampZStrength( double angle );
	MString hikJointName( MStatus * ReturnStatus = NULL ) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareDagMFnConstConstructor( MFnIkJoint, MFn::kJoint );

	//!     NO SCRIPT SUPPORT
	MStatus getHikJointName( MString& name ) const;

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnIkJoint */
