#ifndef _MFnKeyframeDeltaBlockAddRemove
#define _MFnKeyframeDeltaBlockAddRemove
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//
// ****************************************************************************
//
// CLASS:    MFnKeyframeDeltaBlockAddRemove
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnKeyframeDelta.h>

// ****************************************************************************
// DECLARATIONS

class MTimeArray;
class MDoubleArray;
class MTime;

// ****************************************************************************
// CLASS DECLARATION (MFnKeyframeDeltaBlockAddRemove)

//! \ingroup OpenMayaAnim MFn
//! \brief Function set for block add or removal of keys.
/*!
   Certain keyframe editing operations work on group of keys rather than
   an single key. These operations require this function set to
   retrieve changes.

   Function set for reading a block of keyframe changes. They are used
   internally to set a large group of keys quickly. Because changes
   occur in groups using base class keyframe methods on this derived
   class do not make sense.  Therefore, methods describing where the
   block of keys were added or removed are available though methods on
   this class.
*/
class OPENMAYAANIM_EXPORT MFnKeyframeDeltaBlockAddRemove : public MFnKeyframeDelta
{
	declareMFn(MFnKeyframeDeltaBlockAddRemove, MFnKeyframeDelta);

public:
	//! Type of change.
	enum DeltaType {
		kAdded,		//!< Keys were added.
		kRemoved	//!< Keys were removed.
	};

	DeltaType	deltaType( MStatus *ReturnStatus = NULL ) const;
	MTime		startTime( MStatus *ReturnStatus = NULL ) const;
	MTime		endTime( MStatus *ReturnStatus = NULL ) const;
	unsigned int	numKeys( MStatus *ReturnStatus = NULL ) const;

	void		getValues( MDoubleArray &values, MStatus *ReturnStatus = NULL ) const;
	void		getTimes( MTimeArray &times, MStatus *ReturnStatus = NULL ) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnKeyframeDeltaBlockAddRemove, MFnKeyframeDelta );

END_NO_SCRIPT_SUPPORT:

protected:
	// No protected.

private:
	// No private.
};

#endif /* __cplusplus */
#endif /* _MFnKeyframeDeltaBlockAddRemove */
