#ifndef _MFnMotionPath
#define _MFnMotionPath
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnMotionPath
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnDependencyNode.h>
class MDagPath;
class MDagPathArray;
class MDGModifier;
class MTime;

// ****************************************************************************
// CLASS DECLARATION (MFnMotionPath)

//! \ingroup OpenMayaAnim MFn
//! \brief Motion path animation function set 
/*!

  This class is used for constructing and manipulating motion path
  animation.

  Motion path animation requires a curve (or surface) and one or more
  other objects.  During the animation, the objects will be moved
  along the curve.

  Setting "follow" for the motion path aligns the object(s) local axis
  to the tangent of the motion path. Banking can also be applied to
  objects.

  Motion path markers are points along the path where the orientation
  and position for the object(s) travelling along the path can be
  specified.
*/
class OPENMAYAANIM_EXPORT MFnMotionPath : public MFnDependencyNode
{

	declareMFn(MFnMotionPath, MFnDependencyNode);

public:
	//! Available axes.
	enum Axis {
		kXaxis,		//!< \nop
		kYaxis,		//!< \nop
		kZaxis		//!< \nop
	};
	MObject		create( const MDagPath & pathObject,
						const MDagPath & objectToAnimate,
						MTime & timeStart, MTime & timeEnd,
						MDGModifier * modifier = NULL,
						MStatus * ReturnStatus = NULL );
	MStatus		setPathObject( const MDagPath & pathObject,
								 MDGModifier * modifier = NULL );
	MDagPath	pathObject( MStatus * ReturnStatus = NULL );
	MStatus		addAnimatedObject( const MDagPath & objectToAnimate,
									MDGModifier * modifier = NULL );
	MStatus		getAnimatedObjects( MDagPathArray & array );
	MStatus		setFollow( bool on, MDGModifier * modifier = NULL );
	bool		follow( MStatus * ReturnStatus = NULL ) const;
	MStatus		setFollowAxis( Axis axis );
	Axis		followAxis( MStatus * ReturnStatus = NULL );
	MStatus		setUpAxis( Axis axis );
	Axis		upAxis( MStatus * ReturnStatus = NULL );
	MStatus		setBank( bool bank );
	bool		bank( MStatus * ReturnStatus  = NULL) const;
	MStatus		setBankScale( double bankScale );
	double		bankScale( MStatus * ReturnStatus = NULL );
	MStatus		setBankThreshold( double bankThreshold );
	double		bankThreshold( MStatus * ReturnStatus = NULL );
	MStatus		setUseNormal( bool use );
	bool		useNormal( MStatus * ReturnStatus = NULL );
	MStatus		setInverseNormal( bool invert );
	bool		inverseNormal( MStatus * ReturnStatus = NULL );
	MStatus		setUStart( double start );
	MStatus		setUEnd( double end );

	double		uStart( MStatus * ReturnStatus = NULL );
	double		uEnd( MStatus * ReturnStatus = NULL );
	MStatus		setUTimeStart( MTime & start );
	MStatus		setUTimeEnd( MTime & end );
	MTime		uTimeStart( MStatus * ReturnStatus = NULL );
	MTime		uTimeEnd( MStatus * ReturnStatus = NULL );
	unsigned int	numPositionMarkers( MStatus * ReturnStatus = NULL );
	MObject		getPositionMarker( unsigned int, MStatus * ReturnStatus = NULL );
	unsigned int	numOrientationMarkers( MStatus * ReturnStatus = NULL );
	MObject		getOrientationMarker( unsigned int, MStatus * ReturnStatus = NULL );

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnMotionPath, MFnDependencyNode );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
    void *         getCurve();
};

#endif /* __cplusplus */
#endif /* _MFnMotionPath */
