#ifndef _MFnRenderPass
#define _MFnRenderPass
//-
// ==========================================================================
// Copyright (C) 1995 - 2008 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnRenderPass
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MString.h>
#include <maya/MTypes.h>
#include <maya/MFnDependencyNode.h>
#include <maya/MPxRenderPassImpl.h>

// ****************************************************************************
// DECLARATIONS

class MObject;

// ****************************************************************************
// CLASS DECLARATION (MFnRenderPass)

//! \ingroup OpenMayaRender MFn
//! \brief Function set for render passes.
/*!
Provide functionalities for working with render passes such as
retrieving renderer-specific implementations.
*/

class OPENMAYARENDER_EXPORT MFnRenderPass : public MFnDependencyNode
{
	declareMFn(MFnRenderPass, MFnDependencyNode);

public:

	MPxRenderPassImpl* setImplementation( 
		const MString& renderer, 
		MStatus *ReturnStatus = NULL 
		);

	MPxRenderPassImpl* getImplementation() const;

	MPxRenderPassImpl::PassTypeBit frameBufferType( MStatus *ReturnStatus = NULL ) const;

	unsigned int				frameBufferChannels( MStatus *ReturnStatus = NULL ) const;

	bool                        usesFiltering( MStatus *ReturnStatus = NULL ) const;

	MString						passID( MStatus *ReturnStatus = NULL ) const;

	MString						customTokenString( MStatus *ReturnStatus = NULL ) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnRenderPass, MFnDependencyNode );

END_NO_SCRIPT_SUPPORT:

protected:
	// No protected members

private:
	void *renderPass;

};

#endif /* __cplusplus */
#endif /* _MFnRenderLayer */
