#ifndef _MFnScaleManip
#define _MFnScaleManip
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnScaleManip
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnBase.h>
#include <maya/MFnManip3D.h>
#include <maya/MObject.h>

// ****************************************************************************
// CLASS DECLARATION (MFnScaleManip)

//! \ingroup OpenMayaUI MFn
//! \brief ScaleManip function set 
/*!
This class provides access to the built-in Maya scale manipulator.  The
manipulator consists of three constrained-axis scale handles for
non-proportional scaling, and a central handle for proportional scaling.

The manipulator provides data to the plugin through the scale manipVal.
The scale value is a vector consisting of X, Y, and Z scale values.  Each
scale value represents a factor controlling how much an object should be
extended along that dimension.  The scale values are absolute and the initial
scale value has a default of <1.0,1.0,1.0>.

The manipulator can be configured either to display with an object (which
must be a DAG node) or to display at an arbitrary point using the
scaleCenter manipVal.
*/
class OPENMAYAUI_EXPORT MFnScaleManip : public MFnManip3D
{
	declareDagMFn(MFnScaleManip, MFnManip3D);

public:
	MObject		create(MStatus *ReturnStatus = NULL);
	MObject		create(const MString &manipName,
					   const MString &scaleName,
					   MStatus *ReturnStatus = NULL);
	MStatus		connectToScalePlug(const MPlug &scalePlug);
	MStatus		connectToScaleCenterPlug(const MPlug &scaleCenterPlug);
	MStatus		setInitialScale(const MVector& scale);
	MStatus		displayWithNode(const MObject& node);
	MStatus		setSnapMode(bool snapEnabled);
	bool		isSnapModeOn() const;
	MStatus		setSnapIncrement(double snapInc);
	double		snapIncrement() const;
	unsigned int	scaleIndex(MStatus *ReturnStatus = NULL) const;
	unsigned int	scaleCenterIndex(MStatus *ReturnStatus = NULL) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareDagMFnConstConstructor( MFnScaleManip, MFnManip3D );

END_NO_SCRIPT_SUPPORT:

protected:
	// No protected members
private:
	// No private members
};

#endif /* __cplusplus */
#endif /* _MFnScaleManip */
