#ifndef _MFnSet
#define _MFnSet
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnSet
//
// ****************************************************************************
//
// CLASS DESCRIPTION (MFnSet)
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnDependencyNode.h>
#include <maya/MString.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MObjectArray;
class MSelectionList;
class MDagPath;
class TsetCmd;
class Tstring;

// ****************************************************************************
// CLASS DECLARATION (MFnSet)

//! \ingroup OpenMaya MFn
//! \brief Function Set for Sets of Objects. 
/*!
  MFnSet is the function set that is used for manipulating sets of objects.
  Sets in Maya are dependency nodes, so it is possible for one set to
  contain others.

  A set is a list of dependency nodes and dag nodes.  Sets are useful for
  keeping track of lists of objects for many purposes such as selection
  or applying common rendering parameters.  Sets in Maya are also dependency
  nodes, so it is possible for one set to contain others.
*/
class OPENMAYA_EXPORT MFnSet : public MFnDependencyNode
{
	declareMFn(MFnSet, MFnDependencyNode);

public:
	//! Set membership restrictions.
	enum Restriction {
		kNone,			//!< \nop
		kVerticesOnly,		//!< \nop
		kEdgesOnly,		//!< \nop
		kFacetsOnly,		//!< \nop
		kEditPointsOnly,	//!< \nop
		kRenderableOnly		//!< \nop
	};

	MObject     create( const MSelectionList & members,
						         Restriction restriction = kNone,
						         MStatus * ReturnStatus = NULL );

	MStatus     getUnion( const MObject & withSet, MSelectionList & result );
	MStatus     getUnion( const MObjectArray & setList,
						  MSelectionList & result );
	MStatus     getIntersection( const MObject & withSet,
								 MSelectionList & result );
	MStatus     getIntersection( const MObjectArray & setList,
								 MSelectionList & result );

	MStatus     clear();
	MStatus     getMembers( MSelectionList &members, bool flatten ) const;
	MStatus     addMember( const MObject &obj );
	MStatus     addMember( const MDagPath &obj,
						   const MObject &component = MObject::kNullObj );
	MStatus     addMember( const MPlug &plug );
	MStatus     addMembers( const MSelectionList &list );
	MStatus     removeMember( const MObject &obj );
	MStatus     removeMember( const MDagPath &obj, const MObject &component );
	MStatus     removeMember( const MPlug &plug );
	MStatus     removeMembers( const MSelectionList &list );

	bool        isMember( const MObject &object,
						  MStatus * ReturnStatus = NULL ) const;
	bool        isMember( const MDagPath &object,
						  const MObject &component = MObject::kNullObj,
						  MStatus * ReturnStatus = NULL ) const;
	bool        isMember( const MPlug &plug,
						  MStatus * ReturnStatus = NULL ) const;

	bool        intersectsWith( const MObject & otherSet,
								 MStatus * ReturnStatus = NULL ) const;
	bool        hasRestrictions( MStatus * ReturnStatus = NULL ) const;
	Restriction restriction( MStatus * ReturnStatus = NULL ) const;
	MString     annotation( MStatus * ReturnStatus = NULL ) const;
	MStatus     setAnnotation( const MString &annotation );

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnSet, MFnDependencyNode );

	// Obsolete, no script support
	MObject     create( const MSelectionList & members,
						         Restriction restriction = kNone,
						         bool isLayer = false,
						         MStatus * ReturnStatus = NULL );

END_NO_SCRIPT_SUPPORT:

protected:
	// for use for api implementation of classes derived from setCmd
	//
	virtual		Tstring setCommandString();
	virtual		TsetCmd* setCommand();
private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnSet */
