#ifndef _MFnToggleManip
#define _MFnToggleManip
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnToggleManip
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnBase.h>
#include <maya/MFnManip3D.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MPoint;

// ****************************************************************************
// CLASS DECLARATION (MFnToggleManip)

//! \ingroup OpenMayaUI MFn
//! \brief ToggleManip function set 
/*!

  The ToggleManip allows the user to switch between two modes or some
  on/off state. It is drawn as a circle with or without a dot. When
  the mode is on, the dot is drawn in the circle; when the mode is
  off, the circle is drawn without the dot. This manipulator generates
  a boolean value corresponding to whether or not the mode is on or
  off.
*/
class OPENMAYAUI_EXPORT MFnToggleManip : public MFnManip3D
{
	declareDagMFn(MFnToggleManip, MFnManip3D);

public:
	MObject		create(MStatus *ReturnStatus = NULL);
	MObject		create(const MString &manipName,
					   const MString &toggleName,
					   MStatus *ReturnStatus = NULL);
	MStatus		connectToTogglePlug(MPlug &togglePlug);
	MPoint		startPoint(MStatus *ReturnStatus = NULL) const;
	MVector		direction(MStatus *ReturnStatus = NULL) const;
	double		length(MStatus *ReturnStatus = NULL) const;
	bool		toggle(MStatus *ReturnStatus = NULL) const;
	unsigned int	startPointIndex(MStatus *ReturnStatus = NULL) const;
	unsigned int	directionIndex(MStatus *ReturnStatus = NULL) const;
	unsigned int	lengthIndex(MStatus *ReturnStatus = NULL) const;
	unsigned int	toggleIndex(MStatus *ReturnStatus = NULL) const;
	MStatus		setStartPoint(MPoint &startPoint);
	MStatus		setDirection(MVector &direction);
	MStatus		setLength(double length);
	MStatus		setToggle(bool toggle);

BEGIN_NO_SCRIPT_SUPPORT:

 	declareDagMFnConstConstructor( MFnToggleManip, MFnManip3D );

END_NO_SCRIPT_SUPPORT:

protected:

private:

};

#endif /* __cplusplus */
#endif /* _MFnToggleManip */
