#ifndef _MFnUInt64ArrayData
#define _MFnUInt64ArrayData
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnUInt64ArrayData
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnData.h>

// ****************************************************************************
// DECLARATIONS

class MUint64Array;

// ****************************************************************************
// CLASS DECLARATION (MFnUInt64ArrayData)

//! \ingroup OpenMaya MFn
//! \brief MUint64 array function set for dependency node data. 
/*!
  MFnUInt64ArrayData allows the creation and manipulation of MUint64Array data
  objects for use in the dependency graph.

  If a user written dependency node either accepts or produces MUint64Arrays,
  then this class is used to extract or create the data that comes from or
  goes to other dependency graph nodes.  The MDataHandle::type method will
  return kUInt64Array when data of this type is present.  To access it, the
  MDataHandle::data method is used to get an MObject for the data and this
  should then be used to initialize an instance of MFnUInt64ArrayData.
*/
class OPENMAYA_EXPORT MFnUInt64ArrayData : public MFnData
{
	declareMFn(MFnUInt64ArrayData, MFnData);

public:
	unsigned int		length( MStatus* ReturnStatus = NULL ) const;
	MStatus	        	set( MUint64 element, unsigned int index );
	MStatus				copyTo( MUint64Array& ) const;
	MStatus				set( const MUint64Array& newArray );
	MUint64Array		array( MStatus*ReturnStatus=NULL );
	MObject				create( MStatus*ReturnStatus=NULL );
	MObject				create( const MUint64Array& in, MStatus*ReturnStatus=NULL );

BEGIN_NO_SCRIPT_SUPPORT:

	declareMFnConstConstructor( MFnUInt64ArrayData, MFnData );

	//!	NO SCRIPT SUPPORT
	MUint64				operator[]( unsigned int index ) const;
	MUint64&			operator[]( unsigned int index );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnUInt64ArrayData */
