#ifndef _MItDependencyNodes
#define _MItDependencyNodes
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MItDependencyNodes
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MObject.h>
#include <maya/MStatus.h>
#include <maya/MIntArray.h>

// ****************************************************************************
// DECLARATIONS

class MDagPath;
class MDagPathArray;
class MString;
class MIteratorType;

// ****************************************************************************
// CLASS DECLARATION (MItDependencyNodes)

//! \ingroup OpenMaya
//! \brief Dependency Node iterator. 
/*!
Use the dependency node iterator to traverse all the nodes in Maya's
Dependency Graph.

With filtering enabled, the iterator checks to see if the node is
compatible with the type specified by the filter.  See MFn::Type for a
list of all valid types.

Since MObjects may be compatible with more than one type (nodes are
organised in a hierarchy) the MObject::hasFn() method can be used to
further check for compatible types.

Any compatible Function Set can be attached to the retrieved object to
query or or edit it.  Often you will want to use the dependency node
function set (MFnDependencyNode), which is compatible with all
dependency nodes, to perform queries on each node as the iterator
Traverses the Dependency Graph.
*/
class OPENMAYA_EXPORT MItDependencyNodes
{
public:
				MItDependencyNodes( MFn::Type filter = MFn::kInvalid,
									MStatus * ReturnStatus = NULL );
				MItDependencyNodes( MIteratorType& infoObject,
									MStatus * ReturnStatus = NULL );
	virtual		~MItDependencyNodes();

	MStatus		reset( MFn::Type filter = MFn::kInvalid );
	MStatus		reset(MIteratorType& infoObject);

	MObject		thisNode( MStatus * ReturnStatus = NULL ) const;
	MStatus		next();
	bool		isDone( MStatus * ReturnStatus = NULL ) const;

    // obsolete
	MObject		item( MStatus * ReturnStatus = NULL ) const;

protected:
// No protected members

private:
	static const char* className();
	bool objectHasFnOnFilterOrList(const MObject& mobject);

	void*		f_data;
	MFn::Type	f_filter;

	MIntArray	filterList;
	bool		useFilterList;
};

#endif /* __cplusplus */
#endif /* _MItDependencyNodes */
