#ifndef _MIteratorType
#define _MIteratorType
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MIteratorType
//
// ****************************************************************************

#include <maya/MIntArray.h>
#include <maya/MTypes.h>
#include <maya/MStatus.h>

//! \ingroup OpenMaya
//! \brief MIteratorType class 
/*!
The MIteratorType class is used on iterators where more than one type
of filters can be specified. It also provides functionalities to set and
get the filter list or individual types of filter. This class should be
used in conjunction with DAG/DG/DependencyNodes iterators for using filter
list (list of MFn::Type objects) on them, thus enabling faster traversal
thro' iterators.

Also, the class has functionalities for specifying the type of object the
iterator will be reset to. This could be an MObject, an MPlug or an MDagPath.
*/
class OPENMAYA_EXPORT MIteratorType
{
public:

	//! Type of object the iterator deals with.
	enum objFilterType
	{
		//! This is to indicate that the root of the iterator has to be reset to an MObject
		kMObject,
		//! This is to indicate that the root of the iterator has to be reset to an MDagPath object.
		kMDagPathObject,
		//! This is to indicate that the root of the iterator has to be reset to an MPlug object.
		kMPlugObject
	};

						MIteratorType(MStatus* ReturnStatus = NULL);
						MIteratorType( const MIteratorType &, MStatus* ReturnStatus = NULL);
						~MIteratorType();
	void				setFilterType(MFn::Type type, MStatus* ReturnStatus = NULL);
	void				setFilterList(MIntArray& listOfFilters, MStatus* ReturnStatus = NULL);
	void				setObjectType(objFilterType objType, MStatus* ReturnStatus = NULL);
	MFn::Type			getFilterType(MStatus* ReturnStatus = NULL);
	MStatus				getFilterList(MIntArray& listOfFilters);
	MIteratorType::objFilterType
						getObjectType(MStatus* ReturnStatus = NULL);
	bool				filterListEnabled();

private:
	MFn::Type			filterType;
	MIntArray			filterList;
	bool				useFilterList;
	objFilterType		objType;
};

#endif /* _MIteratorType */
