#ifndef _MObject
#define _MObject
//
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All 
// rights reserved.
// 
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors,  which is protected by U.S. and Canadian federal copyright law 
// and by international treaties.
// 
// The Data may not be disclosed or distributed to third parties or be 
// copied or duplicated, in whole or in part, without the prior written 
// consent of Autodesk.
// 
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the following 
// disclaimer, must be included in all copies of the Software, in whole 
// or in part, and all derivative works of the Software, unless such copies 
// or derivative works are solely in the form of machine-executable object 
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, 
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO 
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST 
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR 
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS 
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES. 
// ==========================================================================
//+
//
// CLASS:    MObject
//
// ****************************************************************************
//
// CLASS DESCRIPTION (MObject)
//
//  MObject is the generic class for accessing all Maya internal modelling,
//	animation and rendering Objects, collectively referred to as Model Objects,
//	through the API.  This includes all Dependency Graph (DG) Nodes, of which
//	Directed Acyclic Graph (DAG) Nodes are a subset.
//	
//	Each instance of an MObject represents a specific Node or Attribute on a
//	Node in the DG.  Under the C++ class scheme MObjects simply have type
//	MObject with no base or derived hierarchy.  However,  MObjects may be many
//	different types of Model objects, from Attributes to Xforms, including
//	components of geometry such as Control Vertices (CV), faces, edges and
//	vertices.  This allows many different types of objects to be moved accessed
//	through the API without undue concern on the part of plug-in developers for
//	the type of object being manipulated.
//
//	Since it is impractical to provide every applicable method on MObjects, the
//	methods applicable to Maya Objects are encapsulated in Function Sets.
//	Function Sets can be attached to compatible MObjects to provide an external
//	interface to methods appropriate to that MObject.
//
//  The link between an MObject and the role it performs as a Maya Model object,
//  as well as the compatibility between MObjects and Function Sets is managed
//  by the API Run-Time Type Identification (RTTI) system.  The two key concepts
//  of this system are the Maya Object type and the Function Set type (both in
//  MFn::Type).  All MObjects have one and only one Maya Object type.  All
//  Function Sets have one and only one Function Set type. MObjects may,
//  however, be compatible with many types of Function Sets.  This compatibility
//  follows the class hierarchy of the Function Sets.  Thus an MObject with Maya
//  Object type MFn::kNurbsSurface would be compatible with MFnNurbsSurface,
//  MFnDagNode, MFnDependencyNode, MFnNamedObject and MFnBase.
//
//	Any MObject can be queried with the MObject::hasFn() method to determine if
//	it is comaptible with a given Function Set.
//
//	The purpose of the Base Function Set (MFnBase) is to provide methods for
//	determining whether or not a Function Set is compatible with a given Maya
//	Object (MObject) type (MFn::Type) or a specific MObject.  See:
//					MFnBase::hasObj(MFn::Type)
//							and
//					MFnBase::hasObj(const MObject &)
//
//	As well, this Function Set provides virtual methods for determining the type
//	of a Function Set under the API RTTI system. 
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES

#include <maya/MFn.h>
#include <maya/MTypes.h>
#include <stdio.h>

// ****************************************************************************
// DECLARATIONS

class MPtrBase;
class MObjectHandle;

// ****************************************************************************
// CLASS DECLARATION (MObject)

//! \ingroup OpenMaya
//! Generic Class for Accessing Internal Maya Objects
/*!
Determine the exact type (MFn::Type) of an MObject within Maya.

Determine if an Object exists.

Determine if an Object is compatible with a specific Function Set.

  MObject is the generic class for accessing all Maya internal modelling,
  animation and rendering Objects, collectively referred to as Model Objects,
  through the API.  This includes all Dependency Graph (DG) Nodes, of which
  Directed Acyclic Graph (DAG) Nodes are a subset.
	
  Each instance of an MObject represents a specific Node or Attribute on a
  Node in the DG.  Under the C++ class scheme MObjects simply have type
  MObject with no base or derived hierarchy.  However,  MObjects may be many
  different types of Model objects, from Attributes to transforms, including
  components of geometry such as Control Vertices (CV), faces, edges and
  vertices.  This allows many different types of objects to be moved accessed
  through the API without undue concern on the part of plug-in developers for
  the type of object being manipulated.

  Since it is impractical to provide every applicable method in MObjects, the
  methods applicable to Maya Objects are encapsulated in Function Sets.
  Function Sets can be attached to compatible MObjects to provide an external
  interface to methods appropriate to that MObject.

  The link between an MObject and the role it performs as a Maya Model object,
  as well as the compatibility between MObjects and Function Sets is managed
  by the API Run-Time Type Identification (RTTI) system.  The two key concepts
  of this system are the Maya Object type and the Function Set type (both in
  MFn::Type).  All MObjects have one and only one Maya Object type.  All
  Function Sets have one and only one Function Set type. MObjects may,
  however, be compatible with many types of Function Sets.  This compatibility
  follows the class hierarchy of the Function Sets.  Thus an MObject with Maya
  Object type MFn::kNurbsSurface would be compatible with MFnNurbsSurface,
  MFnDagNode, MFnDependencyNode, MFnNamedObject and MFnBase.

  Use the apiType() method to determine the type (MFn::Type) of the Maya Model
  Object.

  Use hasFn() to determine if the Object is comaptible with a given Function Set.

  Use isNull() to determine if the internal Maya Object exists.

*/
class FND_EXPORT  MObject  
{
public:


	MObject();
	MObject( const MObject &other ); 
	~MObject();
	bool			hasFn( MFn::Type fs ) const;
	bool            isNull() const;
 
    MFn::Type		apiType() const;
	const char *    apiTypeStr() const;
 
	bool			operator == (const MObject &) const;
	bool			operator != (const MObject &) const;
	MObject &		operator =  (const MObject &);

	//! Null Object for use as default argument.
	static MObject  kNullObj;

protected:
// No protected members

private:
	bool			isFlagSet( short ) const;
	void			setFlag( short, bool );
	short			allFlags() const;
	
	friend class	MObjectHandle;

	MPtrBase *		ptr;
	unsigned short	flags;
};

// ****************************************************************************
#endif /* __cplusplus */
#endif /* _MObject */
