#ifndef _MPxComponentShape
#define _MPxComponentShape
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxComponentShape
//
// ****************************************************************************
//
// CLASS DESCRIPTION (MPxComponentShape)
//
//  MPxComponentShape is the parent class of user defined shapes that contain
//  an array of points/control vertices/components.
//
//  MPxComponentShape provides various basic support routines needed for any
//  custom shape that supports components. A copy of the data for those components is
//  stored locally to allow fast access, particularly for draw/pick routines.
//
//  User defined shapes are dependency nodes (and DAG nodes) which contain
//  overridable drawing, and selection methods.
//
//  The UI dependent aspects of the shape should be implemented in a class
//  derived from MPxSurfaceShapeUI. This includes the drawing and interactive
//  selection of the shape and any components that the shape implements.
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES

#include <maya/MPxSurfaceShape.h>
#include <maya/MVectorArray.h>

// ****************************************************************************
// DECLARATIONS

class MSelectionList;
class MPointArray;
class MObjectArray;
class MSelectionMask;

// ****************************************************************************
// CLASS DECLARATION (MPxComponentShape)

//! \ingroup OpenMaya MPx
//! \brief Component helper class for surface shapes. 
/*!

  MPxComponentShape allows the implementation of new user defined
  shapes using components. User defined shapes are dependency nodes
  (and DAG nodes) which contain overridable drawing, selection, and
  component methods. This class provides enhanced functionality for
  working with components. As a result, it is a better starting point
  than MPxSurfaceShape for writing surface shape components.

  This class provides methods to manipulate and select the components that make
  up the shape.

  The UI dependent aspects of the shape should be implemented in a class
  derived from MPxSurfaceShapeUI. This includes the drawing and interactive
  selection of the shape.
*/
class OPENMAYA_EXPORT MPxComponentShape : public MPxSurfaceShape
{
public:

	virtual void transformUsing( const MMatrix & matrix, const MObjectArray & componentList );

	virtual void transformUsing( const MMatrix& mat, const MObjectArray& componentList, MPxSurfaceShape::MVertexCachingMode cachingMode, MPointArray* pointCache);

	virtual void componentToPlugs( MObject & component, MSelectionList & list ) const;

	virtual bool match( const MSelectionMask & mask, const MObjectArray& componentList ) const;


	virtual MObject createFullVertexGroup() const;

	virtual MObject localShapeInAttr() const;

	MVectorArray* getControlPoints();

	MStatus setControlPoints( MVectorArray* cps );

protected:
	MVectorArray    myfCps;

private:
};

#endif /* __cplusplus */
#endif /* _MPxComponentShape */
