#ifndef _MPxConstraintCommand
#define _MPxConstraintCommand
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxConstraintCommand
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>
#include <maya/MObject.h>
#include <maya/MPxCommand.h>
#include <maya/MSyntax.h>
#include <maya/MDagPath.h>

// ****************************************************************************
// DECLARATIONS

class MArgDatabase;
class MPxConstraint;
class MObjectArray;
class MDGModifier;
class MTypeId;

// ****************************************************************************
// CLASS DECLARATION (MPxConstraintCommand)

//! \ingroup OpenMayaAnim MPx
//! \brief Proxy constraint command 
/*!
  MPxConstraintCommand is the base class for user defined constraint
  commands. This command gives all of the flags and options of the
  base constraint command in addition allows user defined flags or
  behaviours. When registering this command, use the
  MFnPlugin::registerConstraintCommand() method. A MPxConstraint is
  also required to be used with MPxConstraintCommand. The
  constraintTypeId() virtual must be implemented to return the correct
  constraint node.
*/
class OPENMAYAANIM_EXPORT MPxConstraintCommand : public MPxCommand
{
public:

	//! Defines the type of target object
	enum TargetType
	{
		kTransform,			//!< Transform target
		kGeometryShape,		//!< Geometry shape(or children of) targets
		kLast				//!< Last value, used for counting
	};

						MPxConstraintCommand();
	virtual 			~MPxConstraintCommand();

	virtual MStatus		doIt(const MArgList &argList);
	virtual MStatus		undoIt();
	virtual MStatus		redoIt();

	virtual MStatus	appendSyntax();

	MPxConstraint *constraintNode();

	// SCRIPT USE ONLY
	MSyntax	_syntax(MStatus *ReturnStatus = NULL) const
		{ return syntax( ReturnStatus ); }

protected:

	virtual MStatus              parseArgs(const MArgList &argList);

	//!	USE _syntax() IN SCRIPT
	MSyntax	syntax(MStatus *ReturnStatus = NULL) const;

	virtual MStatus				doEdit();
	virtual MStatus				doCreate();
	virtual MStatus				doQuery();

	virtual void					createdConstraint(MPxConstraint *constraint);

	virtual bool					supportsOffset() const;

	virtual bool					hasVectorFlags() const;

	virtual MTypeId					constraintTypeId() const;
	virtual MPxConstraintCommand::TargetType targetType() const;

	virtual const MObject&			aimVectorAttribute() const;
	virtual const MObject&			upVectorAttribute() const;
	virtual const MObject&			worldUpMatrixAttribute() const;
	virtual const MObject&			worldUpTypeAttribute() const;
	virtual const MObject&			worldUpVectorAttribute() const;
	virtual const MObject&			offsetAttribute() const;
	virtual const MObject&			constraintInstancedAttribute() const;
	virtual const MObject&			constraintOutputAttribute() const;
	virtual const MObject&			constraintRestAttribute() const;
	virtual const MObject&			constraintEnableRestAttribute() const;
	virtual const MObject&			constraintTargetInstancedAttribute() const;

	virtual const MObject&			constraintTargetAttribute() const;
	virtual const MObject&			constraintTargetWeightAttribute() const;
	virtual const MObject&			objectAttribute() const;

	virtual void					getObjectAttributesArray(MObjectArray& array);

	virtual void                    handleNewTargets( MObject& dagObject );
	virtual MStatus                 handleNewTargets( MDagPath& dagObject );

	virtual MStatus					connectTarget(void *opaqueTarget, int index);
	virtual MStatus					connectTarget(MDagPath &targetPath, int index);

	virtual MStatus					connectObjectAndConstraint( MDGModifier& modifier );

	MStatus							connectGeometryAttribute( void *opaqueTarget,	int index, MObject& constraintAttr );
	
	MStatus							connectTargetAttribute( void *opaqueTarget,	
																							int index, 
																							MObject& constraintAttr );

	MStatus							connectTargetAttribute( MDagPath &targetPath,	int index, 
																							MObject& tarAttr, 
																							MObject& constraintAttr, 
																							bool instanced = false );

	MStatus							connectObjectAttribute( const MObject& objectAttr,
										   const MObject& constraintAttr,
										   bool toConstraint = true, bool instanced = false);

	const MObject					transformObject();

private:


	void* instance;
	void setData(void *ptr);
	MPxConstraint *fUserNode;
};

inline MPxConstraint* MPxConstraintCommand::constraintNode()
{
	return fUserNode;
}

#endif /* __cplusplus */
#endif /* _MPxConstraintCommand */
