#ifndef _MPxContextCommand
#define _MPxContextCommand
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxContextCommand
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>
#include <maya/MStatus.h>
#include <maya/MSyntax.h>
#include <maya/MArgParser.h>

// ****************************************************************************
// DECLARATIONS

class MPxContext;
class MArgParser;

// ****************************************************************************
// CLASS DECLARATION (MPxContextCommand)

//! \ingroup OpenMayaUI MPx
//! \brief Base class for context creation commands 
/*!
This is the base class for context creation commands.

The purpose of this command class is to create instances of
user contexts derived from <b>MPxContext</b>,
and to allow the MEL programmer to edit and query
various properties of the context related to this command.

The user will derive off of this class and override the <b>makeObj</b> method
which will be called when this command is invoked in Maya.

The context command is registered in Maya
using MFnPlugin::registerContextCommand
*/
class OPENMAYAUI_EXPORT MPxContextCommand
{
public:
							MPxContextCommand	();
	virtual					~MPxContextCommand	();
	virtual MStatus			doEditFlags			();
	virtual MStatus			doQueryFlags		();
	virtual MPxContext *	makeObj				();
	virtual MStatus			appendSyntax		();
	MStatus					setResult			(bool result);
	MStatus					setResult			(int result);
	MStatus					setResult			(double result);
	MStatus					setResult			(const MString &result);

	// SCRIPT USE ONLY
	MSyntax	_syntax(MStatus *ReturnStatus = NULL) const
		{ return syntax(ReturnStatus); }
	MArgParser _parser(MStatus *ReturnStatus = NULL) const
		{ return parser(ReturnStatus); }
	//

protected:
	//!	USE _syntax() IN SCRIPT
	MSyntax	syntax(MStatus *ReturnStatus = NULL) const;
	//!	USE _parser() IN SCRIPT
	MArgParser parser(MStatus *ReturnStatus = NULL) const;

private:
	const char *className() const;
	void setData(void *ptr);

	void *instance;
};

#endif /* __cplusplus */
#endif /* _MPxContextCommand */

